/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.signing;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.auth.SigV4Trait;
import software.amazon.smithy.aws.traits.auth.UnsignedPayloadTrait;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.OptionalAuthTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/signing/AwsSignatureVersion4;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolMiddleware;", "service", "", "(Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "order", "", "getOrder", "()B", "isEnabledFor", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "render", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderSigningConfig", "Companion", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nAwsSignatureVersion4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsSignatureVersion4.kt\nsoftware/amazon/smithy/kotlin/codegen/signing/AwsSignatureVersion4\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,99:1\n1#2:100\n43#3:101\n73#3:102\n*S KotlinDebug\n*F\n+ 1 AwsSignatureVersion4.kt\nsoftware/amazon/smithy/kotlin/codegen/signing/AwsSignatureVersion4\n*L\n37#1:101\n54#1:102\n*E\n"})
public class AwsSignatureVersion4
implements ProtocolMiddleware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String service;
    @NotNull
    private final String name;
    private final byte order;

    public AwsSignatureVersion4(@NotNull String service2) {
        Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
        this.service = service2;
        String string = RuntimeTypes.Auth.Signing.AwsSigningCommon.INSTANCE.getAwsHttpSigner().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AwsSigningCommon.AwsHttpSigner.name");
        this.name = string;
        this.order = (byte)126;
        if (!(((CharSequence)this.service).length() > 0)) {
            boolean bl = false;
            String string2 = "service name must be specified";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public byte getOrder() {
        return this.order;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabledFor(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        void $this$expectShape$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Model model = ctx.getModel();
        ShapeId shapeId$iv = ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(shapeId, T::class.java)");
        ServiceShape service2 = (ServiceShape)shape;
        return Companion.hasSigV4AuthScheme(ctx.getModel(), service2, op);
    }

    @Override
    public final void render(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        KotlinWriter.addImport$default(writer, RuntimeTypes.Auth.Signing.AwsSigningCommon.INSTANCE.getAwsHttpSigner(), null, 2, null);
        Object[] objectArray = new Object[]{RuntimeTypes.Auth.Signing.AwsSigningCommon.INSTANCE.getAwsHttpSigner()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "op.execution.signer = #T {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this, op, writer){
            final /* synthetic */ AwsSignatureVersion4 this$0;
            final /* synthetic */ OperationShape $op;
            final /* synthetic */ KotlinWriter $writer;
            {
                this.this$0 = $receiver;
                this.$op = $op;
                this.$writer = $writer;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                this.this$0.renderSigningConfig(this.$op, this.$writer);
            }
        });
    }

    protected void renderSigningConfig(@NotNull OperationShape op, @NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        writer.write("this.signer = config.signer", new Object[0]);
        writer.write("this.credentialsProvider = config.credentialsProvider", new Object[0]);
        Object[] objectArray = new Object[]{this.service};
        writer.write("this.service = #S", objectArray);
        Shape $this$hasTrait$iv = (Shape)op;
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(UnsignedPayloadTrait.class)) {
            writer.write("this.isUnsignedPayload = true", new Object[0]);
        }
    }

    @Override
    public void renderProperties(@NotNull KotlinWriter writer) {
        ProtocolMiddleware.DefaultImpls.renderProperties(this, writer);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/signing/AwsSignatureVersion4$Companion;", "", "()V", "hasSigV4AuthScheme", "", "model", "Lsoftware/amazon/smithy/model/Model;", "service", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "operation", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "isSupportedAuthentication", "serviceShape", "signingServiceName", "", "smithy-kotlin-codegen"})
    @SourceDebugExtension(value={"SMAP\nAwsSignatureVersion4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsSignatureVersion4.kt\nsoftware/amazon/smithy/kotlin/codegen/signing/AwsSignatureVersion4$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,99:1\n1747#2,3:100\n78#3:103\n73#3:104\n*S KotlinDebug\n*F\n+ 1 AwsSignatureVersion4.kt\nsoftware/amazon/smithy/kotlin/codegen/signing/AwsSignatureVersion4$Companion\n*L\n72#1:100,3\n81#1:103\n95#1:104\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupportedAuthentication(@NotNull Model model, @NotNull ServiceShape serviceShape2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Intrinsics.checkNotNullParameter((Object)serviceShape2, (String)"serviceShape");
                Iterable $this$any$iv = ServiceIndex.of((Model)model).getAuthSchemes((ToShapeId)serviceShape2).values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Trait it = (Trait)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getClass(), SigV4Trait.class)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final String signingServiceName(@NotNull ServiceShape serviceShape2) {
            Intrinsics.checkNotNullParameter((Object)serviceShape2, (String)"serviceShape");
            Shape $this$expectTrait$iv = (Shape)serviceShape2;
            boolean $i$f$expectTrait = false;
            Trait trait = $this$expectTrait$iv.expectTrait(SigV4Trait.class);
            Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(T::class.java)");
            SigV4Trait sigv4Trait = (SigV4Trait)trait;
            String string = sigv4Trait.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sigv4Trait.name");
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasSigV4AuthScheme(@NotNull Model model, @NotNull ServiceShape service2, @NotNull OperationShape operation) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Map auth = ServiceIndex.of((Model)model).getEffectiveAuthSchemes((ToShapeId)service2.getId(), (ToShapeId)operation.getId());
            if (!auth.containsKey(SigV4Trait.ID)) return false;
            Shape $this$hasTrait$iv = (Shape)operation;
            boolean $i$f$hasTrait = false;
            if ($this$hasTrait$iv.hasTrait(OptionalAuthTrait.class)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

