/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.core;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.core.ImportDeclarations;
import software.amazon.smithy.kotlin.codegen.core.ImportDeclarationsKt;
import software.amazon.smithy.kotlin.codegen.core.InlineKotlinWriterFormatter;
import software.amazon.smithy.kotlin.codegen.core.KotlinPropertyFormatter;
import software.amazon.smithy.kotlin.codegen.core.KotlinSymbolFormatter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypesKt;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\b\u0002\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u0002`\u00070\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0003J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u0003J'\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001f\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u001f\u0010#\u001a\u00020\u00002\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00150&\u00a2\u0006\u0002\b'J\u001e\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0005H\u0002J\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u0004\u0018\u00010\u00002\u0006\u0010-\u001a\u00020.J\u000e\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u0004\u0018\u00010\u00002\u0006\u00105\u001a\u0002062\u0006\u0010-\u001a\u000207J\b\u00108\u001a\u00020\u0003H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u0002`\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00069"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "Lsoftware/amazon/smithy/utils/AbstractCodeWriter;", "fullPackageName", "", "fullyQualifiedSymbols", "", "Lkotlin/Pair;", "Lsoftware/amazon/smithy/kotlin/codegen/core/FullyQualifiedSymbolName;", "dependencies", "Lsoftware/amazon/smithy/codegen/core/SymbolDependency;", "imports", "Lsoftware/amazon/smithy/kotlin/codegen/core/ImportDeclarations;", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Lsoftware/amazon/smithy/kotlin/codegen/core/ImportDeclarations;)V", "getDependencies", "()Ljava/util/Set;", "getFullPackageName", "()Ljava/lang/String;", "getFullyQualifiedSymbols", "getImports", "()Lsoftware/amazon/smithy/kotlin/codegen/core/ImportDeclarations;", "addDepsRecursively", "", "symbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "addImport", "packageName", "symbolName", "alias", "addImportReferences", "options", "", "Lsoftware/amazon/smithy/codegen/core/SymbolReference$ContextOption;", "(Lsoftware/amazon/smithy/codegen/core/Symbol;[Lsoftware/amazon/smithy/codegen/core/SymbolReference$ContextOption;)Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "cleanForWriter", "doc", "dokka", "docs", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "findAllReferences", "allRefs", "Lsoftware/amazon/smithy/codegen/core/SymbolReference;", "rawString", "renderAnnotations", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "renderDeprecatedAnnotation", "renderDocumentation", "renderEnumDefinitionDocumentation", "enumDefinition", "Lsoftware/amazon/smithy/model/traits/EnumDefinition;", "renderMemberDocumentation", "model", "Lsoftware/amazon/smithy/model/Model;", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "toString", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nKotlinWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinWriter.kt\nsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,377:1\n1855#2,2:378\n1855#2,2:380\n1855#2,2:382\n83#3:384\n1#4:385\n*S KotlinDebug\n*F\n+ 1 KotlinWriter.kt\nsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter\n*L\n106#1:378,2\n118#1:380,2\n127#1:382,2\n221#1:384\n*E\n"})
public final class KotlinWriter
extends AbstractCodeWriter<KotlinWriter> {
    @NotNull
    private final String fullPackageName;
    @NotNull
    private final Set<Pair<String, String>> fullyQualifiedSymbols;
    @NotNull
    private final Set<SymbolDependency> dependencies;
    @NotNull
    private final ImportDeclarations imports;

    public KotlinWriter(@NotNull String fullPackageName, @NotNull Set<Pair<String, String>> fullyQualifiedSymbols, @NotNull Set<SymbolDependency> dependencies, @NotNull ImportDeclarations imports) {
        Intrinsics.checkNotNullParameter((Object)fullPackageName, (String)"fullPackageName");
        Intrinsics.checkNotNullParameter(fullyQualifiedSymbols, (String)"fullyQualifiedSymbols");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)imports, (String)"imports");
        this.fullPackageName = fullPackageName;
        this.fullyQualifiedSymbols = fullyQualifiedSymbols;
        this.dependencies = dependencies;
        this.imports = imports;
        this.trimBlankLines();
        this.trimTrailingSpaces();
        this.setIndentText("    ");
        this.setExpressionStart('#');
        this.putFormatter('T', new KotlinSymbolFormatter(this, (Function1<? super Symbol, Boolean>)((Function1)new Function1<Symbol, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull Symbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                return this.getFullyQualifiedSymbols().contains(ImportDeclarationsKt.toFullyQualifiedSymbolName(symbol2));
            }
        })));
        this.putFormatter('Q', new KotlinSymbolFormatter(this, (Function1<? super Symbol, Boolean>)((Function1)2.INSTANCE)));
        this.putFormatter('P', new KotlinPropertyFormatter(this, false, false, false, 14, null));
        this.putFormatter('F', new KotlinPropertyFormatter(this, false, false, true, 6, null));
        this.putFormatter('D', new KotlinPropertyFormatter(this, true, false, false, 12, null));
        this.putFormatter('E', new KotlinPropertyFormatter(this, true, false, true, 4, null));
        this.putFormatter('W', new InlineKotlinWriterFormatter(this));
    }

    public /* synthetic */ KotlinWriter(String string, Set set, Set set2, ImportDeclarations importDeclarations, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            set2 = new LinkedHashSet();
        }
        if ((n & 8) != 0) {
            importDeclarations = new ImportDeclarations();
        }
        this(string, set, set2, importDeclarations);
    }

    @NotNull
    public final String getFullPackageName() {
        return this.fullPackageName;
    }

    @NotNull
    public final Set<Pair<String, String>> getFullyQualifiedSymbols() {
        return this.fullyQualifiedSymbols;
    }

    @NotNull
    public final Set<SymbolDependency> getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final ImportDeclarations getImports() {
        return this.imports;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final KotlinWriter addImport(@NotNull Symbol symbol2, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (KotlinTypesKt.isBuiltIn(symbol2)) {
            return this;
        }
        this.addDepsRecursively(symbol2);
        String string = symbol2.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"symbol.namespace");
        if (!(((CharSequence)string).length() > 0)) return this;
        if (Intrinsics.areEqual((Object)symbol2.getNamespace(), (Object)this.fullPackageName)) return this;
        if (!SymbolExtKt.isExtension(symbol2)) {
            String string2 = symbol2.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"symbol.namespace");
            String string3 = symbol2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"symbol.name");
            if (this.imports.symbolCollides(string2, string3)) {
                this.fullyQualifiedSymbols.add(ImportDeclarationsKt.toFullyQualifiedSymbolName(symbol2));
                return this;
            }
        }
        String string4 = symbol2.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"symbol.namespace");
        String string5 = symbol2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"symbol.name");
        this.imports.addImport(string4, string5, alias);
        return this;
    }

    public static /* synthetic */ KotlinWriter addImport$default(KotlinWriter kotlinWriter, Symbol symbol2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            String string2 = symbol2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"symbol.name");
            string = string2;
        }
        return kotlinWriter.addImport(symbol2, string);
    }

    @NotNull
    public final KotlinWriter addImportReferences(@NotNull Symbol symbol2, SymbolReference.ContextOption ... options) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Set allRefs = new LinkedHashSet();
        this.findAllReferences(symbol2, allRefs);
        Iterable $this$forEach$iv = allRefs;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            SymbolReference reference = (SymbolReference)element$iv;
            boolean bl = false;
            for (SymbolReference.ContextOption option : options) {
                if (!reference.hasOption((SymbolReference.Option)option)) continue;
                Symbol symbol3 = reference.getSymbol();
                Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"reference.symbol");
                String string = reference.getAlias();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reference.alias");
                this.addImport(symbol3, string);
                continue block0;
            }
        }
        return this;
    }

    private final void findAllReferences(Symbol symbol2, Set<SymbolReference> allRefs) {
        List list = symbol2.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"symbol.references");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolReference ref = (SymbolReference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"ref");
            allRefs.add(ref);
            Symbol symbol3 = ref.getSymbol();
            Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"ref.symbol");
            this.findAllReferences(symbol3, allRefs);
        }
    }

    private final void addDepsRecursively(Symbol symbol2) {
        List list = symbol2.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"symbol.dependencies");
        this.dependencies.addAll(list);
        List list2 = symbol2.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"symbol.references");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolReference it = (SymbolReference)element$iv;
            boolean bl = false;
            Symbol symbol3 = it.getSymbol();
            Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"it.symbol");
            this.addDepsRecursively(symbol3);
        }
    }

    public final void addImport(@NotNull String packageName, @NotNull String symbolName, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)symbolName, (String)"symbolName");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (this.imports.symbolCollides(packageName, symbolName)) {
            this.fullyQualifiedSymbols.add((Pair<String, String>)TuplesKt.to((Object)packageName, (Object)symbolName));
        } else {
            this.imports.addImport(packageName, symbolName, alias);
        }
    }

    public static /* synthetic */ void addImport$default(KotlinWriter kotlinWriter, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = string2;
        }
        kotlinWriter.addImport(string, string2, string3);
    }

    @NotNull
    public final String rawString() {
        String string = super.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        String string = super.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.toString()");
        String contents = string;
        String header = "// Code generated by smithy-kotlin-codegen. DO NOT EDIT!\n\n";
        String importStatements = this.imports + "\n\n";
        String pkgDecl = "package " + this.fullPackageName + "\n\n";
        return header + pkgDecl + importStatements + contents;
    }

    @NotNull
    public final KotlinWriter dokka(@NotNull Function1<? super KotlinWriter, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.pushState();
        this.write("/**", new Object[0]);
        this.setNewlinePrefix(" * ");
        block.invoke((Object)this);
        this.popState();
        this.write(" */", new Object[0]);
        return this;
    }

    @NotNull
    public final KotlinWriter dokka(@NotNull String docs) {
        Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
        return this.dokka((Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(docs){
            final /* synthetic */ String $docs;
            {
                this.$docs = $docs;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$dokka) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
                $this$dokka.write(KotlinWriter.access$cleanForWriter($this$dokka, KotlinWriterKt.formatDocumentation$default(this.$docs, null, 2, null)), new Object[0]);
            }
        }));
    }

    private final String cleanForWriter(String doc) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)doc, (String)"#", (String)"##", (boolean)false, (int)4, null), (String)"/*", (String)"&##47;*", (boolean)false, (int)4, null), (String)"*/", (String)"*&##47;", (boolean)false, (int)4, null);
    }

    public final void renderAnnotations(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.renderDeprecatedAnnotation(shape);
    }

    private final void renderDeprecatedAnnotation(Shape shape) {
        if (ShapeExtKt.isDeprecated(shape)) {
            this.write("@Deprecated(\"No longer recommended for use. See AWS API documentation for more details.\")", new Object[0]);
        }
    }

    @Nullable
    public final KotlinWriter renderDocumentation(@NotNull Shape shape) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape $this$getTrait$iv = shape;
        boolean $i$f$getTrait = false;
        Optional optional = $this$getTrait$iv.getTrait(DocumentationTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(T::class.java)");
        DocumentationTrait documentationTrait = (DocumentationTrait)((Trait)OptionalExtKt.getOrNull(optional));
        if (documentationTrait != null) {
            DocumentationTrait it = documentationTrait;
            boolean bl = false;
            String string = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
            kotlinWriter = this.dokka(string);
        } else {
            kotlinWriter = null;
        }
        return kotlinWriter;
    }

    @Nullable
    public final KotlinWriter renderMemberDocumentation(@NotNull Model model, @NotNull MemberShape shape) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Optional optional = shape.getMemberTrait(model, DocumentationTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"shape.getMemberTrait(mod\u2026ntationTrait::class.java)");
        DocumentationTrait documentationTrait = (DocumentationTrait)OptionalExtKt.getOrNull(optional);
        if (documentationTrait != null) {
            DocumentationTrait it = documentationTrait;
            boolean bl = false;
            String string = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
            kotlinWriter = this.dokka(string);
        } else {
            kotlinWriter = null;
        }
        return kotlinWriter;
    }

    public final void renderEnumDefinitionDocumentation(@NotNull EnumDefinition enumDefinition) {
        Intrinsics.checkNotNullParameter((Object)enumDefinition, (String)"enumDefinition");
        enumDefinition.getDocumentation().ifPresent(arg_0 -> KotlinWriter.renderEnumDefinitionDocumentation$lambda$5((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ KotlinWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.dokka(it);
            }
        }, arg_0));
    }

    private static final void renderEnumDefinitionDocumentation$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$cleanForWriter(KotlinWriter $this, String doc) {
        return $this.cleanForWriter(doc);
    }
}

