/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.test;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.MockManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.KotlinCodegenPlugin;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.model.OperationNormalizer;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.test.AwsProtocolModelDeclaration;
import software.amazon.smithy.kotlin.codegen.test.CodegenTestUtilsKt;
import software.amazon.smithy.kotlin.codegen.test.MockHttpProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.test.ModelTestUtilsKt;
import software.amazon.smithy.kotlin.codegen.test.TestContext;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SmithyIdlModelSerializer;
import software.amazon.smithy.model.validation.ValidatedResultException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a>\u0010\u0004\u001a\u00020\u0005*\u00020\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a6\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0000\u001a2\u0010\u0011\u001a\u00020\u0012*\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u001aT\u0010\u0016\u001a\u00020\u0003*\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00192\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010\u001a\f\u0010\u001a\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\u0018\u0010\u001b\u001a\u00020\u0001*\u00020\u001c2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a,\u0010\u001b\u001a\u00020\u0001*\u00020\u00032\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u000b\u00a8\u0006\u001f"}, d2={"applyKotlinCodegenTransforms", "Lsoftware/amazon/smithy/model/Model;", "serviceShapeId", "", "defaultSettings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "serviceName", "packageName", "packageVersion", "sdkId", "generateDefaultBuildFiles", "", "generateTestModel", "protocol", "namespace", "operations", "", "newTestContext", "Lsoftware/amazon/smithy/kotlin/codegen/test/TestContext;", "settings", "generator", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;", "prependNamespaceAndService", "version", "imports", "Lsoftware/amazon/smithy/kotlin/codegen/test/AwsProtocolModelDeclaration;", "toSmithyIDL", "toSmithyModel", "Ljava/net/URL;", "sourceLocation", "applyDefaultTransforms", "smithy-kotlin-codegen"})
public final class ModelTestUtilsKt {
    /*
     * WARNING - void declaration
     */
    private static final Model applyKotlinCodegenTransforms(Model $this$applyKotlinCodegenTransforms, String serviceShapeId) {
        ShapeId shapeId;
        String string = serviceShapeId;
        if (string != null) {
            shapeId = ShapeId.from((String)string);
        } else {
            Model $this$shapes$iv = $this$applyKotlinCodegenTransforms;
            boolean $i$f$shapes = false;
            Stream stream = $this$shapes$iv.shapes(ServiceShape.class);
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"shapes(T::class.java)");
            List services = StreamsKt.toList((Stream)stream);
            if (!(services.size() <= 1)) {
                boolean $i$a$-check-ModelTestUtilsKt$applyKotlinCodegenTransforms$serviceId$22 = false;
                String $i$a$-check-ModelTestUtilsKt$applyKotlinCodegenTransforms$serviceId$22 = "multiple services discovered in model; auto inference of service shape impossible for test. Fix by passing the service shape explicitly";
                throw new IllegalStateException($i$a$-check-ModelTestUtilsKt$applyKotlinCodegenTransforms$serviceId$22.toString());
            }
            if (services.isEmpty()) {
                return $this$applyKotlinCodegenTransforms;
            }
            shapeId = ((ServiceShape)CollectionsKt.first((List)services)).getId();
        }
        ShapeId serviceId = shapeId;
        List transforms2 = CollectionsKt.listOf((Object)new Function2<Model, ShapeId, Model>((Object)OperationNormalizer.INSTANCE){

            @NotNull
            public final Model invoke(@NotNull Model p0, @NotNull ShapeId p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((OperationNormalizer)this.receiver).transform(p0, p1);
            }
        });
        Iterable $this$fold$iv = transforms2;
        boolean $i$f$fold = false;
        Model accumulator$iv = $this$applyKotlinCodegenTransforms;
        for (Object element$iv : $this$fold$iv) {
            void transform;
            KFunction kFunction = (KFunction)element$iv;
            Model m = accumulator$iv;
            boolean bl = false;
            Function2 function2 = (Function2)transform;
            Intrinsics.checkNotNullExpressionValue((Object)serviceId, (String)"serviceId");
            accumulator$iv = (Model)function2.invoke((Object)m, (Object)serviceId);
        }
        return accumulator$iv;
    }

    @NotNull
    public static final Model toSmithyModel(@NotNull URL $this$toSmithyModel, @Nullable String serviceShapeId) {
        Intrinsics.checkNotNullParameter((Object)$this$toSmithyModel, (String)"<this>");
        Model model = (Model)Model.assembler().addImport($this$toSmithyModel).discoverModels().assemble().unwrap();
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
        return ModelTestUtilsKt.applyKotlinCodegenTransforms(model, serviceShapeId);
    }

    public static /* synthetic */ Model toSmithyModel$default(URL uRL, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ModelTestUtilsKt.toSmithyModel(uRL, string);
    }

    @NotNull
    public static final Model toSmithyModel(@NotNull String $this$toSmithyModel, @Nullable String sourceLocation, @Nullable String serviceShapeId, boolean applyDefaultTransforms) {
        Model model;
        Model model2;
        Intrinsics.checkNotNullParameter((Object)$this$toSmithyModel, (String)"<this>");
        String processed = StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)$this$toSmithyModel)).toString(), (String)"$version", (boolean)false, (int)2, null) ? $this$toSmithyModel : "$version: \"1.0\"\n" + $this$toSmithyModel;
        try {
            ModelAssembler modelAssembler = Model.assembler().discoverModels();
            String string = sourceLocation;
            if (string == null) {
                string = "test.smithy";
            }
            model2 = (Model)modelAssembler.addUnparsedModel(string, processed).assemble().unwrap();
        }
        catch (ValidatedResultException e) {
            System.err.println("Model failed to parse:");
            System.err.println($this$toSmithyModel);
            throw e;
        }
        Model model3 = model2;
        if (applyDefaultTransforms) {
            Intrinsics.checkNotNullExpressionValue((Object)model3, (String)"model");
            model = ModelTestUtilsKt.applyKotlinCodegenTransforms(model3, serviceShapeId);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)model3, (String)"model");
            model = model3;
        }
        return model;
    }

    public static /* synthetic */ Model toSmithyModel$default(String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return ModelTestUtilsKt.toSmithyModel(string, string2, string3, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toSmithyIDL(@NotNull Model $this$toSmithyIDL) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toSmithyIDL, (String)"<this>");
        Object[] objectArray = new String[]{"smithy.test.smithy", "aws.auth.smithy", "aws.protocols.smithy", "aws.api.smithy"};
        Set builtInModelIds = SetsKt.setOf((Object[])objectArray);
        SmithyIdlModelSerializer smithyIdlModelSerializer = SmithyIdlModelSerializer.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)smithyIdlModelSerializer, (String)"builder().build()");
        SmithyIdlModelSerializer ms = smithyIdlModelSerializer;
        Map node = ms.serialize($this$toSmithyIDL);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
        Map $this$filterNot$iv = node;
        boolean $i$f$filterNot = false;
        Map map = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (builtInModelIds.contains(it.getKey().toString())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object object = CollectionsKt.first((Iterable)destination$iv$iv.values());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.filterNot { builtIn\u2026tring()) }.values.first()");
        return (String)object;
    }

    @NotNull
    public static final TestContext newTestContext(@NotNull Model $this$newTestContext, @NotNull String serviceName, @NotNull String packageName, @NotNull KotlinSettings settings, @NotNull ProtocolGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)$this$newTestContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        MockManifest manifest = new MockManifest();
        SymbolProvider provider = CodegenTestUtilsKt.createSymbolProvider$default(KotlinCodegenPlugin.Companion, $this$newTestContext, packageName, null, serviceName, 4, null);
        Object t = ((Shape)$this$newTestContext.getShape(ShapeId.from((String)(packageName + '#' + serviceName))).get()).asServiceShape().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"this.getShape(ShapeId.fr\u2026().asServiceShape().get()");
        ServiceShape service2 = (ServiceShape)t;
        KotlinDelegator delegator = new KotlinDelegator(settings, $this$newTestContext, (FileManifest)manifest, provider, null, 16, null);
        ProtocolGenerator.GenerationContext ctx = new ProtocolGenerator.GenerationContext(settings, $this$newTestContext, service2, provider, CollectionsKt.emptyList(), generator.getProtocol(), delegator);
        return new TestContext(ctx, manifest, generator);
    }

    public static /* synthetic */ TestContext newTestContext$default(Model model, String string, String string2, KotlinSettings kotlinSettings, ProtocolGenerator protocolGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Test";
        }
        if ((n & 2) != 0) {
            string2 = "com.test";
        }
        if ((n & 4) != 0) {
            kotlinSettings = ModelTestUtilsKt.defaultSettings$default(model, string, string2, null, null, false, 28, null);
        }
        if ((n & 8) != 0) {
            protocolGenerator = new MockHttpProtocolGenerator();
        }
        return ModelTestUtilsKt.newTestContext(model, string, string2, kotlinSettings, protocolGenerator);
    }

    @NotNull
    public static final KotlinSettings defaultSettings(@NotNull Model $this$defaultSettings, @Nullable String serviceName, @NotNull String packageName, @NotNull String packageVersion, @NotNull String sdkId, boolean generateDefaultBuildFiles) {
        ShapeId shapeId;
        Intrinsics.checkNotNullParameter((Object)$this$defaultSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)packageVersion, (String)"packageVersion");
        Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
        if (serviceName == null) {
            shapeId = KotlinSettings.Companion.inferService$smithy_kotlin_codegen($this$defaultSettings);
        } else {
            ShapeId shapeId2;
            Optional optional = $this$defaultSettings.getShape(ShapeId.from((String)(packageName + '#' + serviceName)));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"this.getShape(ShapeId.fr\u2026ckageName#$serviceName\"))");
            Shape shape = (Shape)OptionalExtKt.getOrNull(optional);
            Object object = shapeId2 = shape != null ? shape.getId() : null;
            if (shapeId2 == null) {
                throw new IllegalStateException(("Unable to find service '" + serviceName + "' in model.").toString());
            }
            shapeId = shapeId2;
        }
        ShapeId serviceId = shapeId;
        ObjectNode objectNode = Node.objectNodeBuilder().withMember("service", (ToNode)Node.from((String)serviceId.toString())).withMember("package", (ToNode)Node.objectNode().withMember("name", (ToNode)Node.from((String)packageName)).withMember("version", (ToNode)Node.from((String)packageVersion))).withMember("sdkId", (ToNode)Node.from((String)sdkId)).withMember("build", (ToNode)Node.objectNode().withMember("generateDefaultBuildFiles", (ToNode)Node.from((boolean)generateDefaultBuildFiles))).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"objectNodeBuilder()\n    \u2026   )\n            .build()");
        return KotlinSettings.Companion.from($this$defaultSettings, objectNode);
    }

    public static /* synthetic */ KotlinSettings defaultSettings$default(Model model, String string, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = "com.test";
        }
        if ((n & 4) != 0) {
            string3 = "1.0.0";
        }
        if ((n & 8) != 0) {
            string4 = "Test";
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return ModelTestUtilsKt.defaultSettings(model, string, string2, string3, string4, bl);
    }

    @NotNull
    public static final Model generateTestModel(@NotNull String $this$generateTestModel, @NotNull String protocol, @NotNull String namespace, @NotNull String serviceName, @NotNull List<String> operations) {
        Intrinsics.checkNotNullParameter((Object)$this$generateTestModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        String completeModel = StringsKt.trimIndent((String)("\n        namespace " + namespace + "\n\n        use aws.protocols#" + protocol + "\n\n        @" + protocol + "\n        service " + serviceName + " {\n            version: \"1.0.0\",\n            operations: [\n                " + CollectionsKt.joinToString$default((Iterable)operations, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "\n            ]\n        }\n        \n        " + $this$generateTestModel + "\n    "));
        return ModelTestUtilsKt.toSmithyModel$default(completeModel, null, null, false, 7, null);
    }

    public static /* synthetic */ Model generateTestModel$default(String string, String string2, String string3, String string4, List list, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "com.test";
        }
        if ((n & 4) != 0) {
            string4 = "Test";
        }
        return ModelTestUtilsKt.generateTestModel(string, string2, string3, string4, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String prependNamespaceAndService(@NotNull String $this$prependNamespaceAndService, @NotNull String version2, @NotNull String namespace, @NotNull List<String> imports, @NotNull String serviceName, @Nullable AwsProtocolModelDeclaration protocol, @NotNull List<String> operations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$prependNamespaceAndService, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter(imports, (String)"imports");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        String versionExpr = "$version: \"" + version2 + '\"';
        Pair pair = protocol == null ? TuplesKt.to((Object)"", imports) : TuplesKt.to((Object)protocol.getAnnotation(), (Object)CollectionsKt.plus((Collection)imports, (Iterable)CollectionsKt.listOf((Object)protocol.getImport())));
        String modelProtocol = (String)pair.component1();
        List modelImports = (List)pair.component2();
        Iterable $this$map$iv = modelImports;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("use " + (String)it);
        }
        String importExpr2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)prependNamespaceAndService.importExpr.2.INSTANCE, (int)30, null);
        return StringsKt.trimIndent((String)("\n        " + versionExpr + "\n        namespace " + namespace + "\n        " + importExpr2 + "\n        " + modelProtocol + "\n        service " + serviceName + " { \n            version: \"1.0.0\",\n            operations: " + operations + "\n        }\n        \n\n        ")) + StringsKt.trimIndent((String)$this$prependNamespaceAndService);
    }

    public static /* synthetic */ String prependNamespaceAndService$default(String string, String string2, String string3, List list, String string4, AwsProtocolModelDeclaration awsProtocolModelDeclaration, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "1";
        }
        if ((n & 2) != 0) {
            string3 = "com.test";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            string4 = "Test";
        }
        if ((n & 0x10) != 0) {
            awsProtocolModelDeclaration = null;
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ModelTestUtilsKt.prependNamespaceAndService(string, string2, string3, list, string4, awsProtocolModelDeclaration, list2);
    }
}

