/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.aws.protocols;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.protocols.RestJson1Trait;
import software.amazon.smithy.kotlin.codegen.aws.protocols.json.AwsJsonProtocolParserGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.json.JsonHttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolverKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpTraitResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolContentTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataParserGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RestJson1;", "Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/json/JsonHttpBindingProtocolGenerator;", "<init>", "()V", "protocol", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "getProtocol", "()Lsoftware/amazon/smithy/model/shapes/ShapeId;", "getProtocolHttpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "renderSerializeHttpBody", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "structuredDataParser", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataParserGenerator;", "smithy-aws-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nRestJson1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestJson1.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RestJson1\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n295#2,2:71\n*S KotlinDebug\n*F\n+ 1 RestJson1.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RestJson1\n*L\n51#1:71,2\n*E\n"})
public final class RestJson1
extends JsonHttpBindingProtocolGenerator {
    @NotNull
    private final ShapeId protocol;

    public RestJson1() {
        ShapeId shapeId = RestJson1Trait.ID;
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"ID");
        this.protocol = shapeId;
    }

    @NotNull
    public ShapeId getProtocol() {
        return this.protocol;
    }

    @NotNull
    public HttpBindingResolver getProtocolHttpBindingResolver(@NotNull Model model, @NotNull ServiceShape serviceShape) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
        return (HttpBindingResolver)new HttpTraitResolver(model, serviceShape, ProtocolContentTypes.Companion.consistent("application/json"));
    }

    protected void renderSerializeHttpBody(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer) {
        Object v0;
        HttpBindingResolver resolver;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            super.renderSerializeHttpBody(ctx, op, writer);
            resolver = this.getProtocolHttpBindingResolver(ctx.getModel(), ctx.getService());
            if (!HttpBindingResolverKt.hasHttpBody((HttpBindingResolver)resolver, (OperationShape)op)) {
                return;
            }
            List requestBindings = resolver.requestBindings(op);
            Iterable $this$firstOrNull$iv = requestBindings;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpBindingDescriptor it = (HttpBindingDescriptor)element$iv;
                boolean bl = false;
                if (!(it.getLocation() == HttpBinding.Location.PAYLOAD)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        HttpBindingDescriptor httpPayload = v0;
        if (httpPayload != null) {
            String memberName = NamingKt.defaultName((MemberShape)httpPayload.getMember());
            Shape target = ctx.getModel().expectShape(httpPayload.getMember().getTarget());
            Object[] objectArray = new Object[]{memberName};
            AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)writer), (String)"if (input.#L == null) {", (String)"}", (Object[])objectArray, arg_0 -> RestJson1.renderSerializeHttpBody$lambda$1(target, resolver, op, arg_0));
        }
    }

    @Override
    @NotNull
    public StructuredDataParserGenerator structuredDataParser(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (StructuredDataParserGenerator)new AwsJsonProtocolParserGenerator((ProtocolGenerator)this, this.getSupportsJsonNameTrait());
    }

    private static final Unit renderSerializeHttpBody$lambda$1(Shape $target, HttpBindingResolver $resolver, OperationShape $op, KotlinWriter $this$withBlock) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        if ($target instanceof StructureShape) {
            objectArray = new Object[]{RuntimeTypes.Http.INSTANCE.getHttpBody(), "{}"};
            $this$withBlock.write((Object)"builder.body = #T.fromBytes(#S.encodeToByteArray())", objectArray);
        }
        objectArray = new Object[]{$resolver.determineRequestContentType($op)};
        $this$withBlock.write((Object)"builder.headers.setMissing(\"Content-Type\", #S)", objectArray);
        return Unit.INSTANCE;
    }
}

