/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.codegen.protocols.core;

import aws.sdk.kotlin.codegen.AwsRuntimeTypes;
import aws.sdk.kotlin.codegen.AwsServiceUtilsKt;
import aws.sdk.kotlin.codegen.protocols.core.AwsEndpointResolverGenerator;
import aws.sdk.kotlin.codegen.protocols.core.AwsHttpProtocolClientGenerator;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.CodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolClientGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.signing.AwsSignatureVersion4;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Laws/sdk/kotlin/codegen/protocols/core/AwsHttpProtocolClientGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "middlewares", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolMiddleware;", "httpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;)V", "render", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderAdditionalMethods", "renderClose", "renderInternals", "renderMergeServiceDefaults", "renderOperationSetup", "opIndex", "Lsoftware/amazon/smithy/model/knowledge/OperationIndex;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "smithy-aws-kotlin-codegen"})
public class AwsHttpProtocolClientGenerator
extends HttpProtocolClientGenerator {
    public AwsHttpProtocolClientGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> middlewares, @NotNull HttpBindingResolver httpBindingResolver) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(middlewares, (String)"middlewares");
        Intrinsics.checkNotNullParameter((Object)httpBindingResolver, (String)"httpBindingResolver");
        super(ctx, middlewares, httpBindingResolver);
    }

    public void render(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write((Object)"\n\n", new Object[0]);
        Object[] objectArray = new Object[]{AwsServiceUtilsKt.getSdkId(this.getCtx().getService())};
        writer.write((Object)"const val ServiceId: String = #S", objectArray);
        objectArray = new Object[]{this.getCtx().getService().getVersion()};
        writer.write((Object)"const val ServiceApiVersion: String = #S", objectArray);
        objectArray = new Object[]{this.getCtx().getSettings().getPkg().getVersion()};
        writer.write((Object)"const val SdkVersion: String = #S", objectArray);
        writer.write((Object)"\n\n", new Object[0]);
        super.render(writer);
        this.renderInternals();
    }

    protected void renderOperationSetup(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        super.renderOperationSetup(writer, opIndex, op);
        writer.write((Object)"mergeServiceDefaults(op.context)", new Object[0]);
    }

    protected void renderAdditionalMethods(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.renderMergeServiceDefaults(writer);
    }

    private final void renderMergeServiceDefaults(KotlinWriter writer) {
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Auth.Signing.AwsSigningCommon.INSTANCE.getAwsSigningAttributes(), null, (int)2, null);
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)AwsRuntimeTypes.Core.INSTANCE.getAwsClientOption(), null, (int)2, null);
        Symbol putIfAbsentSym2 = SymbolBuilderKt.buildSymbol((Function1)renderMergeServiceDefaults.putIfAbsentSym.1.INSTANCE);
        Symbol sdkClientOptionSym2 = SymbolBuilderKt.buildSymbol((Function1)renderMergeServiceDefaults.sdkClientOptionSym.1.INSTANCE);
        writer.dokka("merge the defaults configured for the service into the execution context before firing off a request");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getExecutionContext()};
        CodeWriterExtKt.withBlock((CodeWriter)((CodeWriter)writer), (String)"private suspend fun mergeServiceDefaults(ctx: #T) {", (String)"}", (Object[])objectArray, (Function1)((Function1)new Function1<KotlinWriter, Unit>(putIfAbsentSym2, sdkClientOptionSym2, this){
            final /* synthetic */ Symbol $putIfAbsentSym;
            final /* synthetic */ Symbol $sdkClientOptionSym;
            final /* synthetic */ AwsHttpProtocolClientGenerator this$0;
            {
                this.$putIfAbsentSym = $putIfAbsentSym;
                this.$sdkClientOptionSym = $sdkClientOptionSym;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                Object[] objectArray = new Object[]{this.$putIfAbsentSym, AwsRuntimeTypes.Core.INSTANCE.getAwsClientOption()};
                $this$withBlock.write((Object)"ctx.#T(#T.Region, config.region)", objectArray);
                objectArray = new Object[]{this.$putIfAbsentSym, this.$sdkClientOptionSym};
                $this$withBlock.write((Object)"ctx.#T(#T.ServiceName, serviceName)", objectArray);
                objectArray = new Object[]{this.$putIfAbsentSym, this.$sdkClientOptionSym};
                $this$withBlock.write((Object)"ctx.#T(#T.LogMode, config.sdkLogMode)", objectArray);
                if (AwsSignatureVersion4.Companion.isSupportedAuthentication(AwsHttpProtocolClientGenerator.access$getCtx(this.this$0).getModel(), AwsHttpProtocolClientGenerator.access$getCtx(this.this$0).getService())) {
                    String signingServiceName = AwsSignatureVersion4.Companion.signingServiceName(AwsHttpProtocolClientGenerator.access$getCtx(this.this$0).getService());
                    Object[] objectArray2 = new Object[]{this.$putIfAbsentSym, RuntimeTypes.Auth.Signing.AwsSigningCommon.INSTANCE.getAwsSigningAttributes(), signingServiceName};
                    $this$withBlock.write((Object)"ctx.#T(#T.SigningService, #S)", objectArray2);
                }
                objectArray = new Object[]{this.$putIfAbsentSym, RuntimeTypes.Auth.Signing.AwsSigningCommon.INSTANCE.getAwsSigningAttributes()};
                $this$withBlock.write((Object)"ctx.#T(#T.SigningRegion, config.region)", objectArray);
                objectArray = new Object[]{this.$putIfAbsentSym, RuntimeTypes.Auth.Signing.AwsSigningCommon.INSTANCE.getAwsSigningAttributes()};
                $this$withBlock.write((Object)"ctx.#T(#T.CredentialsProvider, config.credentialsProvider)", objectArray);
                if (ShapeExtKt.hasIdempotentTokenMember((ServiceShape)AwsHttpProtocolClientGenerator.access$getCtx(this.this$0).getService(), (Model)AwsHttpProtocolClientGenerator.access$getCtx(this.this$0).getModel())) {
                    KotlinWriter.addImport$default((KotlinWriter)$this$withBlock, (Symbol)RuntimeTypes.Core.INSTANCE.getIdempotencyTokenProviderExt(), null, (int)2, null);
                    objectArray = new Object[]{this.$sdkClientOptionSym};
                    $this$withBlock.write((Object)"config.idempotencyTokenProvider?.let { ctx[#T.IdempotencyTokenProvider] = it }", objectArray);
                }
            }
        }));
    }

    protected void renderClose(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.IO.INSTANCE.getCloseable(), null, (int)2, null);
        Object[] objectArray = new Object[]{RuntimeTypes.IO.INSTANCE.getCloseable()};
        writer.write((Object)"", new Object[0]).openBlock("override fun close() {", new Object[0]).write((Object)"client.close()", new Object[0]).write((Object)"(config.credentialsProvider as? #T)?.close()", objectArray).closeBlock("}", new Object[0]).write((Object)"", new Object[0]);
    }

    private final void renderInternals() {
        String string;
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("aws/sdk/kotlin/codegen/endpoints.json");
        if (uRL == null) {
            string = null;
        } else {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            string = new String(byArray, charset);
        }
        if (string == null) {
            throw new CodegenException("could not load endpoints.json resource");
        }
        String endpointsData = string;
        ObjectNode endpointData = Node.parse(endpointsData).expectObjectNode();
        Intrinsics.checkNotNullExpressionValue((Object)endpointData, (String)"endpointData");
        new AwsEndpointResolverGenerator(endpointData).render(this.getCtx());
    }

    public static final /* synthetic */ ProtocolGenerator.GenerationContext access$getCtx(AwsHttpProtocolClientGenerator $this) {
        return $this.getCtx();
    }
}

