/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.codegen;

import aws.sdk.kotlin.codegen.AwsRuntimeTypes;
import aws.sdk.kotlin.codegen.AwsServiceUtilsKt;
import aws.sdk.kotlin.codegen.PresignableOperation;
import aws.sdk.kotlin.codegen.PresignerGenerator;
import aws.sdk.kotlin.codegen.model.traits.Presignable;
import aws.sdk.kotlin.codegen.protocols.middleware.AwsSignatureVersion4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.auth.SigV4Trait;
import software.amazon.smithy.aws.traits.protocols.AwsQueryTrait;
import software.amazon.smithy.aws.traits.protocols.RestJson1Trait;
import software.amazon.smithy.aws.traits.protocols.RestXmlTrait;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.CodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RenderingContext;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.KotlinIntegration;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.integration.SectionWriterBinding;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.ClientConfigGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.ClientConfigProperty;
import software.amazon.smithy.kotlin.codegen.rendering.ClientConfigPropertyType;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.utils.StringsKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u000256B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J4\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002JN\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000e2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010#0\"H\u0002J0\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J \u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002J>\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\t\u001a\u00020\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00072\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u00102\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)2\u0006\u00103\u001a\u000204H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Laws/sdk/kotlin/codegen/PresignerGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/KotlinIntegration;", "()V", "presignerRuntimeSymbols", "", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "getClientProperties", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/ClientConfigProperty;", "sigv4ServiceName", "", "serviceId", "normalizeUriPathValueForService", "presignConfigFnVisitorFactory", "Laws/sdk/kotlin/codegen/PresignerGenerator$PresignConfigFnVisitor;", "protocol", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "renderPresignConfigBuilder", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "presignConfigTypeName", "renderingContext", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "clientProperties", "renderPresignConfigFn", "requestTypeName", "requestConfigFnName", "presignableOp", "Laws/sdk/kotlin/codegen/PresignableOperation;", "serializerSymbol", "presignConfigFnVisitor", "contextMap", "", "", "renderPresignFromClientFn", "serviceClientTypeName", "renderPresignFromConfigFn", "renderPresigner", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "httpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "presignOperations", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "signBody", "", "useDoubleUriEncodeValueForService", "writeAdditionalFiles", "delegator", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;", "PresignConfigFnSection", "PresignConfigFnVisitor", "smithy-aws-kotlin-codegen"})
public final class PresignerGenerator
implements KotlinIntegration {
    @NotNull
    private final Set<Symbol> presignerRuntimeSymbols;

    public PresignerGenerator() {
        Object[] objectArray = new Symbol[]{RuntimeTypes.Http.Request.INSTANCE.getHttpRequest(), RuntimeTypes.Core.INSTANCE.getExecutionContext(), AwsRuntimeTypes.Types.INSTANCE.getCredentialsProvider(), AwsRuntimeTypes.Config.Credentials.INSTANCE.getDefaultChainCredentialsProvider(), AwsRuntimeTypes.Signing.INSTANCE.getPresignedRequestConfig(), AwsRuntimeTypes.Signing.INSTANCE.getServicePresignConfig(), AwsRuntimeTypes.Signing.INSTANCE.getSigningLocation(), AwsRuntimeTypes.Signing.INSTANCE.getCreatePresignedRequest(), AwsRuntimeTypes.Endpoint.INSTANCE.getAwsEndpointResolver()};
        this.presignerRuntimeSymbols = SetsKt.setOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public void writeAdditionalFiles(@NotNull CodegenContext ctx, @NotNull KotlinDelegator delegator) {
        OperationShape operationShape;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$expectShape$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        Model model = ctx.getModel();
        ShapeId shapeId$iv = ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(shapeId, T::class.java)");
        ServiceShape service = (ServiceShape)shape;
        ProtocolGenerator protocolGenerator = ctx.getProtocolGenerator();
        if (protocolGenerator == null) {
            throw new NullPointerException("null cannot be cast to non-null type software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGenerator");
        }
        HttpBindingProtocolGenerator protocolGenerator2 = (HttpBindingProtocolGenerator)protocolGenerator;
        HttpBindingResolver httpBindingResolver = protocolGenerator2.getProtocolHttpBindingResolver(ctx.getModel(), service);
        TimestampFormatTrait.Format defaultTimestampFormat = protocolGenerator2.getDefaultTimestampFormat();
        if (!AwsSignatureVersion4.Companion.isSupportedAuthentication(ctx.getModel(), service)) {
            return;
        }
        Iterable iterable = service.getAllOperations();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"service.allOperations");
        iterable = iterable;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$expectShape$iv2;
            void it;
            ShapeId shapeId = (ShapeId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Model model2 = ctx.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            void shapeId$iv2 = it;
            boolean $i$f$expectShape2 = false;
            Shape shape2 = $this$expectShape$iv2.expectShape((ShapeId)shapeId$iv2, OperationShape.class);
            Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"expectShape(shapeId, T::class.java)");
            collection.add((OperationShape)shape2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            operationShape = (OperationShape)element$iv$iv;
            boolean bl = false;
            if (!operationShape.hasTrait(Presignable.Companion.getID())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            operationShape = (OperationShape)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (!AwsSignatureVersion4.Companion.hasSigV4AuthScheme(ctx.getModel(), service, operationShape)) {
                boolean $i$a$-check-PresignerGenerator$writeAdditionalFiles$presignOperations$3$22 = false;
                String $i$a$-check-PresignerGenerator$writeAdditionalFiles$presignOperations$3$22 = "Operation does not have valid auth trait";
                throw new IllegalStateException($i$a$-check-PresignerGenerator$writeAdditionalFiles$presignOperations$3$22.toString());
            }
            ProtocolGenerator protocolGenerator3 = ctx.getProtocolGenerator();
            if (protocolGenerator3 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            String protocol = protocolGenerator3.getProtocol().getName();
            Intrinsics.checkNotNullExpressionValue((Object)protocol, (String)"protocol");
            boolean shouldSignBody = this.signBody(protocol);
            String string = service.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"service.id.toString()");
            String string2 = string;
            string = operationShape.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"operationShape.id.toString()");
            collection.add(new PresignableOperation(string2, string, shouldSignBody));
        }
        List presignOperations = (List)destination$iv$iv;
        if (!((Collection)presignOperations).isEmpty()) {
            delegator.useFileWriter("Presigners.kt", Intrinsics.stringPlus((String)ctx.getSettings().getPkg().getName(), (Object)".presigners"), (Function1)new Function1<KotlinWriter, Unit>(this, ctx, httpBindingResolver, service, (List<PresignableOperation>)presignOperations, defaultTimestampFormat){
                final /* synthetic */ PresignerGenerator this$0;
                final /* synthetic */ CodegenContext $ctx;
                final /* synthetic */ HttpBindingResolver $httpBindingResolver;
                final /* synthetic */ ServiceShape $service;
                final /* synthetic */ List<PresignableOperation> $presignOperations;
                final /* synthetic */ TimestampFormatTrait.Format $defaultTimestampFormat;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    this.$httpBindingResolver = $httpBindingResolver;
                    this.$service = $service;
                    this.$presignOperations = $presignOperations;
                    this.$defaultTimestampFormat = $defaultTimestampFormat;
                    super(1);
                }

                public final void invoke(@NotNull KotlinWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    Shape $this$expectTrait$iv = (Shape)this.$service;
                    boolean $i$f$expectTrait = false;
                    Trait trait = $this$expectTrait$iv.expectTrait(SigV4Trait.class);
                    Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(T::class.java)");
                    String string = ((SigV4Trait)trait).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"service.expectTrait<SigV4Trait>().name");
                    PresignerGenerator.access$renderPresigner(this.this$0, writer, this.$ctx, this.$httpBindingResolver, string, this.$presignOperations, this.$defaultTimestampFormat);
                }
            });
        }
    }

    private final boolean signBody(String protocol) {
        return Intrinsics.areEqual((Object)protocol, (Object)"awsQuery");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderPresigner(KotlinWriter writer, CodegenContext ctx, HttpBindingResolver httpBindingResolver, String sigv4ServiceName, List<PresignableOperation> presignOperations, TimestampFormatTrait.Format defaultTimestampFormat) {
        void $this$expectShape$iv;
        Model model = ctx.getModel();
        ShapeId shapeId$iv = ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(shapeId, T::class.java)");
        ServiceShape serviceShape = (ServiceShape)shape;
        Symbol serviceSymbol = ctx.getSymbolProvider().toSymbol((Shape)serviceShape);
        Symbol defaultEndpointResolverSymbol2 = SymbolBuilderKt.buildSymbol((Function1)((Function1)new Function1<SymbolBuilder, Unit>(ctx){
            final /* synthetic */ CodegenContext $ctx;
            {
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                $this$buildSymbol.setNamespace(Intrinsics.stringPlus((String)this.$ctx.getSettings().getPkg().getName(), (Object)".internal"));
                $this$buildSymbol.setName("DefaultEndpointResolver");
            }
        }));
        String clientName = NamingKt.clientName((String)ctx.getSettings().getSdkId());
        String presignConfigTypeName = Intrinsics.stringPlus((String)clientName, (Object)"PresignConfig");
        KotlinWriterKt.addImport((KotlinWriter)writer, (Iterable)this.presignerRuntimeSymbols);
        Intrinsics.checkNotNullExpressionValue((Object)serviceSymbol, (String)"serviceSymbol");
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)serviceSymbol, null, (int)2, null);
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)defaultEndpointResolverSymbol2, null, (int)2, null);
        Iterable $this$forEach$iv = presignOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$expectShape$iv2;
            void $this$expectShape$iv3;
            PresignableOperation presignableOp = (PresignableOperation)element$iv;
            boolean bl = false;
            Model model2 = ctx.getModel();
            String shapeId$iv2 = presignableOp.getOperationId();
            boolean $i$f$expectShape22 = false;
            Shape shape2 = $this$expectShape$iv3.expectShape(ShapeId.from((String)shapeId$iv2), OperationShape.class);
            Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"this.expectShape(ShapeId\u2026(shapeId), T::class.java)");
            OperationShape op = (OperationShape)shape2;
            shapeId$iv2 = ctx.getModel();
            Object $i$f$expectShape22 = op.getInput().get();
            Intrinsics.checkNotNullExpressionValue($i$f$expectShape22, (String)"op.input.get()");
            ShapeId shapeId$iv3 = (ShapeId)$i$f$expectShape22;
            boolean $i$f$expectShape32 = false;
            Pair[] pairArray = $this$expectShape$iv2.expectShape(shapeId$iv3, StructureShape.class);
            Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"expectShape(shapeId, T::class.java)");
            StructureShape request = (StructureShape)pairArray;
            Symbol serializerSymbol2 = SymbolBuilderKt.buildSymbol((Function1)((Function1)new Function1<SymbolBuilder, Unit>(op, ctx){
                final /* synthetic */ OperationShape $op;
                final /* synthetic */ CodegenContext $ctx;
                {
                    this.$op = $op;
                    this.$ctx = $ctx;
                    super(1);
                }

                public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                    $this$buildSymbol.setDefinitionFile(Intrinsics.stringPlus((String)SerdeExtKt.serializerName((OperationShape)this.$op), (Object)".kt"));
                    $this$buildSymbol.setName(SerdeExtKt.serializerName((OperationShape)this.$op));
                    $this$buildSymbol.setNamespace(Intrinsics.stringPlus((String)this.$ctx.getSettings().getPkg().getName(), (Object)".transform"));
                }
            }));
            shapeId$iv3 = ctx.getSymbolProvider().toSymbol((Shape)request);
            Intrinsics.checkNotNullExpressionValue((Object)shapeId$iv3, (String)"ctx.symbolProvider.toSymbol(request)");
            KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)shapeId$iv3, null, (int)2, null);
            KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)serializerSymbol2, null, (int)2, null);
            String requestConfigFnName = Intrinsics.stringPlus((String)NamingKt.defaultName((OperationShape)op), (Object)"PresignConfig");
            this.renderPresignFromConfigFn(writer, NamingKt.defaultName((Shape)((Shape)request), (ServiceShape)serviceShape), requestConfigFnName);
            String string = NamingKt.defaultName((Shape)((Shape)request), (ServiceShape)serviceShape);
            String $i$f$expectShape32 = serviceSymbol.getName();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$expectShape32, (String)"serviceSymbol.name");
            this.renderPresignFromClientFn(writer, string, requestConfigFnName, $i$f$expectShape32, presignConfigTypeName);
            pairArray = new Pair[]{TuplesKt.to((Object)"OperationId", (Object)presignableOp.getOperationId()), TuplesKt.to((Object)"CodegenContext", (Object)ctx), TuplesKt.to((Object)"HttpBindingResolver", (Object)httpBindingResolver), TuplesKt.to((Object)"DefaultTimestampFormat", (Object)defaultTimestampFormat)};
            Map contextMap = MapsKt.mapOf((Pair[])pairArray);
            String string2 = NamingKt.defaultName((Shape)((Shape)request), (ServiceShape)serviceShape);
            ProtocolGenerator protocolGenerator = ctx.getProtocolGenerator();
            Intrinsics.checkNotNull((Object)protocolGenerator);
            this.renderPresignConfigFn(writer, string2, requestConfigFnName, presignableOp, serializerSymbol2, this.presignConfigFnVisitorFactory(protocolGenerator.getProtocol()), contextMap);
        }
        List<ClientConfigProperty> clientProperties = this.getClientProperties(sigv4ServiceName, AwsServiceUtilsKt.getSdkId(serviceShape));
        RenderingContext rc = new RenderingContext(writer, (Shape)serviceShape, ctx.getModel(), ctx.getSymbolProvider(), ctx.getSettings(), null, null, 96, null);
        this.renderPresignConfigBuilder(writer, presignConfigTypeName, (RenderingContext<ServiceShape>)rc, clientProperties);
    }

    private final void renderPresignConfigBuilder(KotlinWriter writer, String presignConfigTypeName, RenderingContext<ServiceShape> renderingContext, List<ClientConfigProperty> clientProperties) {
        writer.dokka((Function1)renderPresignConfigBuilder.1.INSTANCE);
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)AwsRuntimeTypes.Core.INSTANCE.getClientException(), null, (int)2, null);
        writer.putContext("configClass.name", (Object)presignConfigTypeName);
        Collection $this$toTypedArray$iv = clientProperties;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ClientConfigProperty[] clientConfigPropertyArray = thisCollection$iv.toArray(new ClientConfigProperty[0]);
        if (clientConfigPropertyArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ClientConfigProperty[] clientConfigPropertyArray2 = clientConfigPropertyArray;
        ClientConfigGenerator ccg = new ClientConfigGenerator(renderingContext, false, AwsRuntimeTypes.Signing.INSTANCE.getServicePresignConfig(), Arrays.copyOf(clientConfigPropertyArray2, clientConfigPropertyArray2.length));
        ccg.render();
    }

    private final PresignConfigFnVisitor presignConfigFnVisitorFactory(ShapeId protocol) {
        PresignConfigFnVisitor presignConfigFnVisitor;
        ShapeId shapeId = protocol;
        if (Intrinsics.areEqual((Object)shapeId, (Object)RestJson1Trait.ID) ? true : Intrinsics.areEqual((Object)shapeId, (Object)RestXmlTrait.ID)) {
            presignConfigFnVisitor = new PresignConfigFnVisitor(){

                public void renderHttpMethod(@NotNull KotlinWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    writer.write((Object)"httpRequestBuilder.method,", new Object[0]);
                }

                public void renderQueryParameters(@NotNull KotlinWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Http.INSTANCE.getQueryParameters(), null, (int)2, null);
                    writer.write((Object)"httpRequestBuilder.url.parameters.build(),", new Object[0]);
                }
            };
        } else if (Intrinsics.areEqual((Object)shapeId, (Object)AwsQueryTrait.ID)) {
            presignConfigFnVisitor = new PresignConfigFnVisitor(){

                public void renderHttpMethod(@NotNull KotlinWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Http.INSTANCE.getHttpMethod(), null, (int)2, null);
                    writer.write((Object)"HttpMethod.GET,", new Object[0]);
                }

                public void renderQueryParameters(@NotNull KotlinWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Http.INSTANCE.getQueryParameters(), null, (int)2, null);
                    KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Http.INSTANCE.getToByteStream(), null, (int)2, null);
                    KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Core.Content.INSTANCE.getDecodeToString(), null, (int)2, null);
                    KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Http.Util.INSTANCE.getSplitAsQueryParameters(), null, (int)2, null);
                    writer.write((Object)"httpRequestBuilder.body.toByteStream()?.decodeToString()?.splitAsQueryParameters() ?: QueryParameters.Empty,", new Object[0]);
                }
            };
        } else {
            throw new CodegenException(Intrinsics.stringPlus((String)"Unhandled protocol ", (Object)protocol));
        }
        return presignConfigFnVisitor;
    }

    private final void renderPresignConfigFn(KotlinWriter writer, String requestTypeName, String requestConfigFnName, PresignableOperation presignableOp, Symbol serializerSymbol2, PresignConfigFnVisitor presignConfigFnVisitor, Map<String, ? extends Object> contextMap) {
        Object[] objectArray = new Object[]{KotlinTypes.Time.INSTANCE.getDuration()};
        CodeWriterExtKt.withBlock((CodeWriter)((CodeWriter)writer), (String)("private suspend fun " + requestConfigFnName + "(input: " + requestTypeName + ", duration: #T) : PresignedRequestConfig {"), (String)"}\n", (Object[])objectArray, (Function1)((Function1)new Function1<KotlinWriter, Unit>(writer, contextMap, serializerSymbol2, presignConfigFnVisitor, presignableOp){
            final /* synthetic */ KotlinWriter $writer;
            final /* synthetic */ Map<String, Object> $contextMap;
            final /* synthetic */ Symbol $serializerSymbol;
            final /* synthetic */ PresignConfigFnVisitor $presignConfigFnVisitor;
            final /* synthetic */ PresignableOperation $presignableOp;
            {
                this.$writer = $writer;
                this.$contextMap = $contextMap;
                this.$serializerSymbol = $serializerSymbol;
                this.$presignConfigFnVisitor = $presignConfigFnVisitor;
                this.$presignableOp = $presignableOp;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                CodeWriterExtKt.declareSection((CodeWriter)((CodeWriter)this.$writer), (SectionId)PresignConfigFnSection.INSTANCE, this.$contextMap, (Function1)((Function1)new Function1<KotlinWriter, Unit>(this.$serializerSymbol, this.$writer, this.$presignConfigFnVisitor, this.$presignableOp){
                    final /* synthetic */ Symbol $serializerSymbol;
                    final /* synthetic */ KotlinWriter $writer;
                    final /* synthetic */ PresignConfigFnVisitor $presignConfigFnVisitor;
                    final /* synthetic */ PresignableOperation $presignableOp;
                    {
                        this.$serializerSymbol = $serializerSymbol;
                        this.$writer = $writer;
                        this.$presignConfigFnVisitor = $presignConfigFnVisitor;
                        this.$presignableOp = $presignableOp;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                        Intrinsics.checkNotNullParameter((Object)$this$declareSection, (String)"$this$declareSection");
                        $this$declareSection.write((Object)"require(duration.isPositive()) { \"duration must be greater than zero\" }", new Object[0]);
                        Object[] objectArray = new Object[]{this.$serializerSymbol};
                        $this$declareSection.write((Object)"val httpRequestBuilder = #T().serialize(ExecutionContext.build {  }, input)", objectArray);
                        CodeWriterExtKt.withBlock((CodeWriter)((CodeWriter)this.$writer), (String)"return PresignedRequestConfig(", (String)")", (Object[])new Object[0], (Function1)((Function1)new Function1<KotlinWriter, Unit>(this.$presignConfigFnVisitor, this.$writer, this.$presignableOp){
                            final /* synthetic */ PresignConfigFnVisitor $presignConfigFnVisitor;
                            final /* synthetic */ KotlinWriter $writer;
                            final /* synthetic */ PresignableOperation $presignableOp;
                            {
                                this.$presignConfigFnVisitor = $presignConfigFnVisitor;
                                this.$writer = $writer;
                                this.$presignableOp = $presignableOp;
                                super(1);
                            }

                            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                                this.$presignConfigFnVisitor.renderHttpMethod($this$withBlock);
                                $this$withBlock.write((Object)"httpRequestBuilder.url.path,", new Object[0]);
                                this.$presignConfigFnVisitor.renderQueryParameters(this.$writer);
                                $this$withBlock.write((Object)"duration,", new Object[0]);
                                $this$withBlock.write((Object)("" + this.$presignableOp.getSignBody() + ','), new Object[0]);
                                $this$withBlock.write((Object)"SigningLocation.QUERY_STRING", new Object[0]);
                            }
                        }));
                    }
                }));
            }
        }));
    }

    private final void renderPresignFromClientFn(KotlinWriter writer, String requestTypeName, String requestConfigFnName, String serviceClientTypeName, String presignConfigTypeName) {
        writer.dokka((Function1)new Function1<KotlinWriter, Unit>(requestTypeName, serviceClientTypeName){
            final /* synthetic */ String $requestTypeName;
            final /* synthetic */ String $serviceClientTypeName;
            {
                this.$requestTypeName = $requestTypeName;
                this.$serviceClientTypeName = $serviceClientTypeName;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$dokka) {
                Intrinsics.checkNotNullParameter((Object)$this$dokka, (String)"$this$dokka");
                $this$dokka.write((Object)("Presign a [" + this.$requestTypeName + "] using a [" + this.$serviceClientTypeName + "]."), new Object[0]);
                $this$dokka.write((Object)"@param config the client configuration used to generate the presigned request.", new Object[0]);
                $this$dokka.write((Object)"@param duration the amount of time from signing for which the request is valid, with seconds granularity.", new Object[0]);
                $this$dokka.write((Object)"@return The [HttpRequest] that can be invoked within the specified time window.", new Object[0]);
            }
        });
        Object[] objectArray = new Object[]{KotlinTypes.Time.INSTANCE.getDuration()};
        CodeWriterExtKt.withBlock((CodeWriter)((CodeWriter)KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)KotlinTypes.Time.INSTANCE.getDuration(), null, (int)2, null)), (String)("suspend fun " + requestTypeName + ".presign(config: " + serviceClientTypeName + ".Config, duration: #T): HttpRequest {"), (String)"}\n", (Object[])objectArray, (Function1)((Function1)new Function1<KotlinWriter, Unit>(presignConfigTypeName, requestConfigFnName){
            final /* synthetic */ String $presignConfigTypeName;
            final /* synthetic */ String $requestConfigFnName;
            {
                this.$presignConfigTypeName = $presignConfigTypeName;
                this.$requestConfigFnName = $requestConfigFnName;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                CodeWriterExtKt.withBlock((CodeWriter)((CodeWriter)$this$withBlock), (String)("val presignConfig = " + this.$presignConfigTypeName + " {"), (String)"}", (Object[])new Object[0], (Function1)renderPresignFromClientFn.1.INSTANCE);
                $this$withBlock.write((Object)("return createPresignedRequest(presignConfig, " + this.$requestConfigFnName + "(this, duration))"), new Object[0]);
            }
        }));
    }

    private final void renderPresignFromConfigFn(KotlinWriter writer, String requestTypeName, String requestConfigFnName) {
        writer.dokka((Function1)new Function1<KotlinWriter, Unit>(requestTypeName){
            final /* synthetic */ String $requestTypeName;
            {
                this.$requestTypeName = $requestTypeName;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$dokka) {
                Intrinsics.checkNotNullParameter((Object)$this$dokka, (String)"$this$dokka");
                $this$dokka.write((Object)("Presign a [" + this.$requestTypeName + "] using a [ServicePresignConfig]."), new Object[0]);
                $this$dokka.write((Object)"@param presignConfig the configuration used to generate the presigned request", new Object[0]);
                $this$dokka.write((Object)"@param duration the amount of time from signing for which the request is valid, with seconds granularity.", new Object[0]);
                $this$dokka.write((Object)"@return The [HttpRequest] that can be invoked within the specified time window.", new Object[0]);
            }
        });
        Object[] objectArray = new Object[]{KotlinTypes.Time.INSTANCE.getDuration()};
        CodeWriterExtKt.withBlock((CodeWriter)((CodeWriter)KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)KotlinTypes.Time.INSTANCE.getDuration(), null, (int)2, null)), (String)("suspend fun " + requestTypeName + ".presign(presignConfig: ServicePresignConfig, duration: #T): HttpRequest {"), (String)"}\n", (Object[])objectArray, (Function1)((Function1)new Function1<KotlinWriter, Unit>(requestConfigFnName){
            final /* synthetic */ String $requestConfigFnName;
            {
                this.$requestConfigFnName = $requestConfigFnName;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                $this$withBlock.write((Object)("return createPresignedRequest(presignConfig, " + this.$requestConfigFnName + "(this, duration))"), new Object[0]);
            }
        }));
    }

    private final List<ClientConfigProperty> getClientProperties(String sigv4ServiceName, String serviceId) {
        Object[] objectArray = new ClientConfigProperty[]{ClientConfigProperty.Companion.invoke((Function1)getClientProperties.1.INSTANCE), ClientConfigProperty.Companion.invoke((Function1)getClientProperties.2.INSTANCE), ClientConfigProperty.Companion.invoke((Function1)getClientProperties.3.INSTANCE), ClientConfigProperty.Companion.invoke((Function1)new Function1<ClientConfigProperty.Builder, Unit>(sigv4ServiceName){
            final /* synthetic */ String $sigv4ServiceName;
            {
                this.$sigv4ServiceName = $sigv4ServiceName;
                super(1);
            }

            public final void invoke(@NotNull ClientConfigProperty.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.setSymbol(KotlinTypes.INSTANCE.getString());
                $this$invoke.setName("signingName");
                $this$invoke.setDocumentation("Service identifier used to sign requests");
                $this$invoke.setBaseClass(AwsRuntimeTypes.Signing.INSTANCE.getServicePresignConfig());
                $this$invoke.setPropertyType((ClientConfigPropertyType)new ClientConfigPropertyType.ConstantValue(StringsKt.dq((String)this.$sigv4ServiceName)));
            }
        }), ClientConfigProperty.Companion.invoke((Function1)new Function1<ClientConfigProperty.Builder, Unit>(serviceId){
            final /* synthetic */ String $serviceId;
            {
                this.$serviceId = $serviceId;
                super(1);
            }

            public final void invoke(@NotNull ClientConfigProperty.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.setSymbol(KotlinTypes.INSTANCE.getString());
                $this$invoke.setName("serviceId");
                $this$invoke.setDocumentation("Service identifier used to resolve endpoints");
                $this$invoke.setBaseClass(AwsRuntimeTypes.Signing.INSTANCE.getServicePresignConfig());
                $this$invoke.setPropertyType((ClientConfigPropertyType)new ClientConfigPropertyType.ConstantValue(StringsKt.dq((String)this.$serviceId)));
            }
        }), ClientConfigProperty.Companion.invoke((Function1)new Function1<ClientConfigProperty.Builder, Unit>(this, serviceId){
            final /* synthetic */ PresignerGenerator this$0;
            final /* synthetic */ String $serviceId;
            {
                this.this$0 = $receiver;
                this.$serviceId = $serviceId;
                super(1);
            }

            public final void invoke(@NotNull ClientConfigProperty.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.setSymbol(SymbolBuilderKt.buildSymbol((Function1)getClientProperties.1.INSTANCE));
                $this$invoke.setName("useDoubleUriEncode");
                $this$invoke.setDocumentation("Determines if presigner should double encode Uri");
                $this$invoke.setBaseClass(AwsRuntimeTypes.Signing.INSTANCE.getServicePresignConfig());
                $this$invoke.setPropertyType((ClientConfigPropertyType)new ClientConfigPropertyType.ConstantValue(PresignerGenerator.access$useDoubleUriEncodeValueForService(this.this$0, this.$serviceId)));
            }
        }), ClientConfigProperty.Companion.invoke((Function1)new Function1<ClientConfigProperty.Builder, Unit>(this, serviceId){
            final /* synthetic */ PresignerGenerator this$0;
            final /* synthetic */ String $serviceId;
            {
                this.this$0 = $receiver;
                this.$serviceId = $serviceId;
                super(1);
            }

            public final void invoke(@NotNull ClientConfigProperty.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.setSymbol(SymbolBuilderKt.buildSymbol((Function1)getClientProperties.1.INSTANCE));
                $this$invoke.setName("normalizeUriPath");
                $this$invoke.setDocumentation("Determines if presigned URI path will be normalized");
                $this$invoke.setBaseClass(AwsRuntimeTypes.Signing.INSTANCE.getServicePresignConfig());
                $this$invoke.setPropertyType((ClientConfigPropertyType)new ClientConfigPropertyType.ConstantValue(PresignerGenerator.access$normalizeUriPathValueForService(this.this$0, this.$serviceId)));
            }
        })};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String useDoubleUriEncodeValueForService(String serviceId) {
        return String.valueOf(!Intrinsics.areEqual((Object)serviceId, (Object)"S3"));
    }

    private final String normalizeUriPathValueForService(String serviceId) {
        return this.useDoubleUriEncodeValueForService(serviceId);
    }

    public byte getOrder() {
        return KotlinIntegration.DefaultImpls.getOrder((KotlinIntegration)this);
    }

    @NotNull
    public List<ProtocolGenerator> getProtocolGenerators() {
        return KotlinIntegration.DefaultImpls.getProtocolGenerators((KotlinIntegration)this);
    }

    @NotNull
    public List<SectionWriterBinding> getSectionWriters() {
        return KotlinIntegration.DefaultImpls.getSectionWriters((KotlinIntegration)this);
    }

    @NotNull
    public List<ClientConfigProperty> additionalServiceConfigProps(@NotNull CodegenContext ctx) {
        return KotlinIntegration.DefaultImpls.additionalServiceConfigProps((KotlinIntegration)this, (CodegenContext)ctx);
    }

    @NotNull
    public List<ProtocolMiddleware> customizeMiddleware(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> resolved) {
        return KotlinIntegration.DefaultImpls.customizeMiddleware((KotlinIntegration)this, (ProtocolGenerator.GenerationContext)ctx, resolved);
    }

    @NotNull
    public SymbolProvider decorateSymbolProvider(@NotNull KotlinSettings settings, @NotNull Model model, @NotNull SymbolProvider symbolProvider) {
        return KotlinIntegration.DefaultImpls.decorateSymbolProvider((KotlinIntegration)this, (KotlinSettings)settings, (Model)model, (SymbolProvider)symbolProvider);
    }

    public boolean enabledForService(@NotNull Model model, @NotNull KotlinSettings settings) {
        return KotlinIntegration.DefaultImpls.enabledForService((KotlinIntegration)this, (Model)model, (KotlinSettings)settings);
    }

    public void onShapeWriterUse(@NotNull KotlinSettings settings, @NotNull Model model, @NotNull SymbolProvider symbolProvider, @NotNull KotlinWriter writer, @NotNull Shape definedShape) {
        KotlinIntegration.DefaultImpls.onShapeWriterUse((KotlinIntegration)this, (KotlinSettings)settings, (Model)model, (SymbolProvider)symbolProvider, (KotlinWriter)writer, (Shape)definedShape);
    }

    @NotNull
    public Model preprocessModel(@NotNull Model model, @NotNull KotlinSettings settings) {
        return KotlinIntegration.DefaultImpls.preprocessModel((KotlinIntegration)this, (Model)model, (KotlinSettings)settings);
    }

    public static final /* synthetic */ void access$renderPresigner(PresignerGenerator $this, KotlinWriter writer, CodegenContext ctx, HttpBindingResolver httpBindingResolver, String sigv4ServiceName, List presignOperations, TimestampFormatTrait.Format defaultTimestampFormat) {
        $this.renderPresigner(writer, ctx, httpBindingResolver, sigv4ServiceName, presignOperations, defaultTimestampFormat);
    }

    public static final /* synthetic */ String access$useDoubleUriEncodeValueForService(PresignerGenerator $this, String serviceId) {
        return $this.useDoubleUriEncodeValueForService(serviceId);
    }

    public static final /* synthetic */ String access$normalizeUriPathValueForService(PresignerGenerator $this, String serviceId) {
        return $this.normalizeUriPathValueForService(serviceId);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Laws/sdk/kotlin/codegen/PresignerGenerator$PresignConfigFnSection;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "CodegenContext", "", "DefaultTimestampFormat", "HttpBindingResolver", "OperationId", "smithy-aws-kotlin-codegen"})
    public static final class PresignConfigFnSection
    implements SectionId {
        @NotNull
        public static final PresignConfigFnSection INSTANCE = new PresignConfigFnSection();
        @NotNull
        public static final String CodegenContext = "CodegenContext";
        @NotNull
        public static final String OperationId = "OperationId";
        @NotNull
        public static final String HttpBindingResolver = "HttpBindingResolver";
        @NotNull
        public static final String DefaultTimestampFormat = "DefaultTimestampFormat";

        private PresignConfigFnSection() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Laws/sdk/kotlin/codegen/PresignerGenerator$PresignConfigFnVisitor;", "", "renderHttpMethod", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderQueryParameters", "smithy-aws-kotlin-codegen"})
    public static interface PresignConfigFnVisitor {
        public void renderHttpMethod(@NotNull KotlinWriter var1);

        public void renderQueryParameters(@NotNull KotlinWriter var1);
    }
}

