/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.codegen.protocols.core;

import aws.sdk.kotlin.codegen.AwsRuntimeTypes;
import aws.sdk.kotlin.codegen.AwsServiceUtilsKt;
import aws.sdk.kotlin.codegen.protocols.core.AwsEndpointResolverGenerator;
import aws.sdk.kotlin.codegen.protocols.core.AwsHttpProtocolClientGenerator;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.auth.UnsignedPayloadTrait;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolClientGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Laws/sdk/kotlin/codegen/protocols/core/AwsHttpProtocolClientGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "middlewares", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolMiddleware;", "httpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;)V", "defaultHttpClientEngineSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "getDefaultHttpClientEngineSymbol", "()Lsoftware/amazon/smithy/codegen/core/Symbol;", "render", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderAdditionalMethods", "renderInternals", "renderMergeServiceDefaults", "renderOperationSetup", "opIndex", "Lsoftware/amazon/smithy/model/knowledge/OperationIndex;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "smithy-aws-kotlin-codegen"})
public class AwsHttpProtocolClientGenerator
extends HttpProtocolClientGenerator {
    public AwsHttpProtocolClientGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> middlewares, @NotNull HttpBindingResolver httpBindingResolver) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(middlewares, (String)"middlewares");
        Intrinsics.checkNotNullParameter((Object)httpBindingResolver, (String)"httpBindingResolver");
        super(ctx, middlewares, httpBindingResolver);
    }

    @NotNull
    protected Symbol getDefaultHttpClientEngineSymbol() {
        return SymbolBuilderKt.buildSymbol((Function1)defaultHttpClientEngineSymbol.1.INSTANCE);
    }

    public void render(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write((Object)"\n\n", new Object[0]);
        Object[] objectArray = new Object[]{AwsServiceUtilsKt.getSdkId(this.getCtx().getService())};
        writer.write((Object)"const val ServiceId: String = #S", objectArray);
        objectArray = new Object[]{this.getCtx().getService().getVersion()};
        writer.write((Object)"const val ServiceApiVersion: String = #S", objectArray);
        objectArray = new Object[]{this.getCtx().getSettings().getPkg().getVersion()};
        writer.write((Object)"const val SdkVersion: String = #S", objectArray);
        writer.write((Object)"\n\n", new Object[0]);
        super.render(writer);
        this.renderInternals();
    }

    protected void renderOperationSetup(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        super.renderOperationSetup(writer, opIndex, op);
        if (op.hasTrait(UnsignedPayloadTrait.class)) {
            KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)AwsRuntimeTypes.Core.INSTANCE.getAuthAttributes(), null, (int)2, null);
            writer.write((Object)"op.context[AuthAttributes.UnsignedPayload] = true", new Object[0]);
        }
        writer.write((Object)"mergeServiceDefaults(op.context)", new Object[0]);
    }

    protected void renderAdditionalMethods(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.renderMergeServiceDefaults(writer);
    }

    private final void renderMergeServiceDefaults(KotlinWriter writer) {
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)RuntimeTypes.Core.INSTANCE.getExecutionContext(), null, (int)2, null);
        KotlinWriterKt.addImport$default((KotlinWriter)writer, (String)"SdkClientOption", (KotlinDependency)KotlinDependency.Companion.getCORE(), (String)Intrinsics.stringPlus((String)KotlinDependency.Companion.getCORE().getNamespace(), (Object)".client"), null, (int)8, null);
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)AwsRuntimeTypes.Core.INSTANCE.getAuthAttributes(), null, (int)2, null);
        KotlinWriter.addImport$default((KotlinWriter)writer, (Symbol)AwsRuntimeTypes.Core.INSTANCE.getAwsClientOption(), null, (int)2, null);
        KotlinWriterKt.addImport$default((KotlinWriter)writer, (String)"putIfAbsent", (KotlinDependency)KotlinDependency.Companion.getUTILS(), null, null, (int)12, null);
        writer.dokka("merge the defaults configured for the service into the execution context before firing off a request");
        writer.openBlock("private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {", "}", () -> AwsHttpProtocolClientGenerator.renderMergeServiceDefaults$lambda-0(writer, this));
    }

    private final void renderInternals() {
        String string;
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("aws/sdk/kotlin/codegen/endpoints.json");
        if (uRL == null) {
            string = null;
        } else {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            string = new String(byArray, charset);
        }
        if (string == null) {
            throw new CodegenException("could not load endpoints.json resource");
        }
        String endpointsData = string;
        ObjectNode endpointData = Node.parse(endpointsData).expectObjectNode();
        Intrinsics.checkNotNullExpressionValue((Object)endpointData, (String)"endpointData");
        new AwsEndpointResolverGenerator(endpointData).render(this.getCtx());
    }

    private static final void renderMergeServiceDefaults$lambda-0(KotlinWriter $writer, AwsHttpProtocolClientGenerator this$0) {
        Intrinsics.checkNotNullParameter((Object)$writer, (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $writer.write((Object)"ctx.putIfAbsent(AwsClientOption.Region, config.region)", new Object[0]);
        $writer.write((Object)"ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)", new Object[0]);
        $writer.write((Object)"ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)", new Object[0]);
        $writer.write((Object)"ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)", new Object[0]);
        if (ShapeExtKt.hasIdempotentTokenMember((ServiceShape)this$0.getCtx().getService(), (Model)this$0.getCtx().getModel())) {
            KotlinWriter.addImport$default((KotlinWriter)$writer, (Symbol)RuntimeTypes.Core.INSTANCE.getIdempotencyTokenProviderExt(), null, (int)2, null);
            $writer.write((Object)"config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }", new Object[0]);
        }
    }
}

