/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe.internal;

import software.amazon.s3.shaded.dev.failsafe.RetryPolicy;
import software.amazon.s3.shaded.dev.failsafe.RetryPolicyConfig;
import software.amazon.s3.shaded.dev.failsafe.function.CheckedBiPredicate;
import software.amazon.s3.shaded.dev.failsafe.internal.RetryPolicyExecutor;
import software.amazon.s3.shaded.dev.failsafe.spi.DelayablePolicy;
import software.amazon.s3.shaded.dev.failsafe.spi.FailurePolicy;
import software.amazon.s3.shaded.dev.failsafe.spi.PolicyExecutor;

public class RetryPolicyImpl<R>
implements RetryPolicy<R>,
FailurePolicy<R>,
DelayablePolicy<R> {
    private final RetryPolicyConfig<R> config;

    public RetryPolicyImpl(RetryPolicyConfig<R> config) {
        this.config = config;
    }

    @Override
    public RetryPolicyConfig<R> getConfig() {
        return this.config;
    }

    public boolean isAbortable(R result, Throwable failure) {
        for (CheckedBiPredicate<R, Throwable> predicate : this.config.getAbortConditions()) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new RetryPolicyExecutor(this, policyIndex);
    }
}

