/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.request.ObjectContent;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;

public class StreamUtils {
    private static final int BUFFER_SIZE = 8192;
    private static final Logger LOG = LoggerFactory.getLogger(StreamUtils.class);

    public static byte[] toByteArray(ObjectContent objectContent, ObjectKey objectKey, Range range, long timeoutMs) throws IOException, TimeoutException {
        InputStream inStream = objectContent.getStream();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Void> future = executorService.submit(() -> {
            try {
                int numBytesRead;
                LOG.debug("Starting to read from InputStream for Block s3URI={}, etag={}, start={}, end={}", new Object[]{objectKey.s3URI, objectKey.etag, range.getStart(), range.getEnd()});
                while ((numBytesRead = inStream.read(buffer, 0, buffer.length)) != -1) {
                    outStream.write(buffer, 0, numBytesRead);
                }
                LOG.debug("Successfully read from InputStream for Block numBytesRead={}, s3URI={}, etag={}, start={}, end={}", new Object[]{numBytesRead, objectKey.s3URI, objectKey.etag, range.getStart(), range.getEnd()});
                Void void_ = null;
                return void_;
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Cannot close non-null stream", (Throwable)e);
                    }
                }
            }
        });
        try {
            future.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            LOG.debug("Reading from InputStream has timed out for Block s3URI={}, etag={}, start={}, end={}", new Object[]{objectKey.s3URI, objectKey.etag, range.getStart(), range.getEnd()});
            throw new TimeoutException("Read operation timed out");
        }
        catch (Exception e) {
            throw new IOException("Error reading stream", e);
        }
        finally {
            executorService.shutdown();
        }
        return outStream.toByteArray();
    }
}

