/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;

public final class RangeOptimiser {
    private final PhysicalIOConfiguration configuration;

    public List<List<Integer>> optimizeReads(List<Integer> blockIndexes) {
        if (blockIndexes == null || blockIndexes.isEmpty()) {
            return new ArrayList<List<Integer>>();
        }
        int blocksPerTargetRequest = this.calculateBlocksPerTargetRequest();
        int maxBlocksBeforeSplit = this.calculateMaxBlocksBeforeSplit(blocksPerTargetRequest);
        List<List<Integer>> sequentialGroups = this.groupSequentialBlocks(blockIndexes);
        return this.splitLargeGroups(sequentialGroups, maxBlocksBeforeSplit, blocksPerTargetRequest);
    }

    private int calculateBlocksPerTargetRequest() {
        return Math.max(1, (int)(this.configuration.getTargetRequestSize() / this.configuration.getReadBufferSize()));
    }

    private int calculateMaxBlocksBeforeSplit(int blocksPerTargetRequest) {
        return (int)Math.round((double)blocksPerTargetRequest * this.configuration.getRequestToleranceRatio());
    }

    private List<List<Integer>> groupSequentialBlocks(List<Integer> blockIndexes) {
        ArrayList<List<Integer>> sequentialGroups = new ArrayList<List<Integer>>();
        ArrayList<Integer> currentSequence = new ArrayList<Integer>();
        currentSequence.add(blockIndexes.get(0));
        for (int i = 1; i < blockIndexes.size(); ++i) {
            int previous;
            int current = blockIndexes.get(i);
            if (current == (previous = blockIndexes.get(i - 1).intValue()) + 1) {
                currentSequence.add(current);
                continue;
            }
            sequentialGroups.add(currentSequence);
            currentSequence = new ArrayList();
            currentSequence.add(current);
        }
        if (!currentSequence.isEmpty()) {
            sequentialGroups.add(currentSequence);
        }
        return sequentialGroups;
    }

    private List<List<Integer>> splitLargeGroups(List<List<Integer>> sequentialGroups, int maxBlocksBeforeSplit, int blocksPerTargetRequest) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        for (List<Integer> group : sequentialGroups) {
            if (group.size() <= maxBlocksBeforeSplit) {
                result.add(group);
                continue;
            }
            result.addAll(this.splitGroupIntoChunks(group, maxBlocksBeforeSplit, blocksPerTargetRequest));
        }
        return result;
    }

    private List<List<Integer>> splitGroupIntoChunks(List<Integer> group, int maxBlocksBeforeSplit, int blocksPerTargetRequest) {
        List<List<Integer>> chunks = this.createInitialChunks(group, blocksPerTargetRequest);
        this.mergeSmallFinalChunk(chunks, maxBlocksBeforeSplit);
        return chunks;
    }

    private List<List<Integer>> createInitialChunks(List<Integer> group, int blocksPerTargetRequest) {
        ArrayList<List<Integer>> chunks = new ArrayList<List<Integer>>(group.size() / blocksPerTargetRequest + 1);
        for (int i = 0; i < group.size(); i += blocksPerTargetRequest) {
            int endIndex = Math.min(i + blocksPerTargetRequest, group.size());
            chunks.add(new ArrayList<Integer>(group.subList(i, endIndex)));
        }
        return chunks;
    }

    private void mergeSmallFinalChunk(List<List<Integer>> chunks, int maxBlocksBeforeSplit) {
        if (chunks.size() < 2) {
            return;
        }
        List<Integer> lastChunk = chunks.get(chunks.size() - 1);
        List<Integer> previousChunk = chunks.get(chunks.size() - 2);
        if (lastChunk.size() + previousChunk.size() <= maxBlocksBeforeSplit) {
            previousChunk.addAll(lastChunk);
            chunks.remove(chunks.size() - 1);
        }
    }

    @Generated
    public RangeOptimiser(PhysicalIOConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public PhysicalIOConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeOptimiser)) {
            return false;
        }
        RangeOptimiser other = (RangeOptimiser)o;
        PhysicalIOConfiguration this$configuration = this.getConfiguration();
        PhysicalIOConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalIOConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RangeOptimiser(configuration=" + this.getConfiguration() + ")";
    }
}

