/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe;

import java.util.Collections;
import java.util.List;
import software.amazon.s3.shaded.dev.failsafe.FailsafeExecutor;
import software.amazon.s3.shaded.dev.failsafe.Policy;
import software.amazon.s3.shaded.dev.failsafe.internal.util.Assert;
import software.amazon.s3.shaded.dev.failsafe.internal.util.Lists;

public class Failsafe {
    @SafeVarargs
    public static <R, P extends Policy<R>> FailsafeExecutor<R> with(P outerPolicy, P ... policies) {
        Assert.notNull(outerPolicy, "outerPolicy");
        return new FailsafeExecutor(Lists.of(outerPolicy, policies));
    }

    public static <R> FailsafeExecutor<R> with(List<? extends Policy<R>> policies) {
        Assert.notNull(policies, "policies");
        Assert.isTrue(!policies.isEmpty(), "At least one policy must be supplied", new Object[0]);
        return new FailsafeExecutor(policies);
    }

    public static <R> FailsafeExecutor<R> none() {
        return new FailsafeExecutor(Collections.emptyList());
    }
}

