/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Metrics;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStoreIndexCache;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Block;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.RangeOptimiser;
import software.amazon.s3.analyticsaccelerator.io.physical.prefetcher.SequentialReadProgression;
import software.amazon.s3.analyticsaccelerator.io.physical.reader.StreamReader;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.util.AnalyticsAcceleratorUtils;
import software.amazon.s3.analyticsaccelerator.util.BlockKey;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class BlockManager
implements Closeable {
    private final ObjectKey objectKey;
    private final ObjectMetadata metadata;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="Field is injected and may be used in the future")
    private final Telemetry telemetry;
    private final PhysicalIOConfiguration configuration;
    private final Metrics aggregatingMetrics;
    private final BlobStoreIndexCache indexCache;
    private final StreamReader streamReader;
    private final BlockStore blockStore;
    private final SequentialReadProgression sequentialReadProgression;
    private final RangeOptimiser rangeOptimiser;
    private final OpenStreamInformation openStreamInformation;
    private final int maxGeneration;
    private static final String OPERATION_MAKE_RANGE_AVAILABLE = "block.manager.make.range.available";
    private static final Logger LOG = LoggerFactory.getLogger(BlockManager.class);

    public BlockManager(@NonNull ObjectKey objectKey, @NonNull ObjectClient objectClient, @NonNull ObjectMetadata metadata, @NonNull Telemetry telemetry, @NonNull PhysicalIOConfiguration configuration, @NonNull Metrics aggregatingMetrics, @NonNull BlobStoreIndexCache indexCache, @NonNull OpenStreamInformation openStreamInformation, @NonNull ExecutorService threadPool) {
        if (objectKey == null) {
            throw new NullPointerException("objectKey is marked non-null but is null");
        }
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (aggregatingMetrics == null) {
            throw new NullPointerException("aggregatingMetrics is marked non-null but is null");
        }
        if (indexCache == null) {
            throw new NullPointerException("indexCache is marked non-null but is null");
        }
        if (openStreamInformation == null) {
            throw new NullPointerException("openStreamInformation is marked non-null but is null");
        }
        if (threadPool == null) {
            throw new NullPointerException("threadPool is marked non-null but is null");
        }
        this.objectKey = objectKey;
        this.metadata = metadata;
        this.telemetry = telemetry;
        this.configuration = configuration;
        this.aggregatingMetrics = aggregatingMetrics;
        this.indexCache = indexCache;
        this.blockStore = new BlockStore(indexCache, aggregatingMetrics, configuration);
        this.openStreamInformation = openStreamInformation;
        this.streamReader = new StreamReader(objectClient, objectKey, threadPool, this::removeBlocks, aggregatingMetrics, openStreamInformation, telemetry, configuration);
        this.sequentialReadProgression = new SequentialReadProgression(configuration);
        this.rangeOptimiser = new RangeOptimiser(configuration);
        this.maxGeneration = this.sequentialReadProgression.getMaximumGeneration();
        this.prefetchSmallObject();
    }

    private void prefetchSmallObject() {
        if (AnalyticsAcceleratorUtils.isSmallObject(this.configuration, this.metadata.getContentLength())) {
            try {
                this.makeRangeAvailable(0L, this.metadata.getContentLength(), ReadMode.SMALL_OBJECT_PREFETCH);
            }
            catch (Exception e) {
                LOG.debug("Failed to prefetch small object for key: {}", (Object)this.objectKey.getS3URI().getKey(), (Object)e);
            }
        }
    }

    public synchronized void makePositionAvailable(long pos, ReadMode readMode) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        this.makeRangeAvailable(pos, 1L, readMode);
    }

    public synchronized void makeRangeAvailable(long pos, long len, ReadMode readMode) {
        long effectiveEnd;
        List<Integer> missingBlockIndexes;
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0L <= len, "`len` must not be negative");
        long endPos = pos + len - 1L;
        if (this.isRangeAvailable(pos, endPos)) {
            return;
        }
        long generation = this.getGeneration(pos, readMode);
        long maxReadLength = Math.max(len, this.configuration.getReadAheadBytes());
        if (generation > 0L) {
            maxReadLength = Math.max(maxReadLength, this.sequentialReadProgression.getSizeForGeneration(generation));
        }
        if ((missingBlockIndexes = this.blockStore.getMissingBlockIndexesInRange(new Range(pos, effectiveEnd = this.truncatePos(pos + maxReadLength - 1L)))).isEmpty()) {
            LOG.debug("All blocks are in store for key: {}, pos: {}, len: {}, effectiveEnd: {}", new Object[]{this.objectKey.getS3URI().getKey(), pos, len, effectiveEnd});
            return;
        }
        this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_MAKE_RANGE_AVAILABLE)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(pos, pos + len - 1L))).attribute(StreamAttributes.effectiveRange(pos, effectiveEnd))).attribute(StreamAttributes.generation(generation))).build(), () -> {
            List<List<Integer>> groupedReads = this.splitReads(missingBlockIndexes);
            for (List<Integer> group : groupedReads) {
                ArrayList<Block> blocksToFill = new ArrayList<Block>();
                for (int blockIndex : group) {
                    BlockKey blockKey = new BlockKey(this.objectKey, this.getBlockIndexRange(blockIndex));
                    Block block = new Block(blockKey, generation, this.indexCache, this.aggregatingMetrics);
                    this.blockStore.add(block);
                    blocksToFill.add(block);
                }
                this.streamReader.read(blocksToFill, readMode);
            }
        });
    }

    private List<List<Integer>> splitReads(List<Integer> blockIndexes) {
        return this.rangeOptimiser.optimizeReads(blockIndexes);
    }

    private long getGeneration(long pos, ReadMode readMode) {
        if (!readMode.allowRequestExtension() || pos < this.configuration.getReadBufferSize()) {
            return 0L;
        }
        Optional<Block> previousBlock = this.blockStore.getBlock(pos - 1L);
        long generation = previousBlock.map(block -> block.getGeneration() + 1L).orElse(0L);
        return Math.min(generation, (long)this.maxGeneration);
    }

    private long truncatePos(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        return Math.min(pos, this.getLastObjectByte());
    }

    private boolean isRangeAvailable(long pos, long endPos) {
        List<Integer> missingBlockIndexes = this.blockStore.getMissingBlockIndexesInRange(new Range(pos, endPos));
        return missingBlockIndexes.isEmpty();
    }

    private long getLastObjectByte() {
        return this.metadata.getContentLength() - 1L;
    }

    private Range getBlockIndexRange(int blockIndex) {
        long start = (long)blockIndex * this.configuration.getReadBufferSize();
        long end = Math.min(start + this.configuration.getReadBufferSize() - 1L, this.getLastObjectByte());
        return new Range(start, end);
    }

    public synchronized Optional<Block> getBlock(long pos) {
        return this.blockStore.getBlock(pos);
    }

    private synchronized void removeBlocks(List<Block> blocks) {
        blocks.forEach(this.blockStore::remove);
    }

    public boolean isBlockStoreEmpty() {
        return this.blockStore.isEmpty();
    }

    public void cleanUp() {
        this.blockStore.cleanUp();
    }

    @Override
    public void close() {
        this.blockStore.close();
        this.streamReader.close();
    }
}

