/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Metrics;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Blob;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStoreIndexCache;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockManager;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.MetricKey;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Inner class is created very infrequently, and fluency justifies the extra pointer")
public class BlobStore
implements Closeable {
    private final Map<ObjectKey, Blob> blobMap;
    private final ObjectClient objectClient;
    private final Telemetry telemetry;
    private final PhysicalIOConfiguration configuration;
    private final ExecutorService threadPool;
    private final Metrics metrics;
    final BlobStoreIndexCache indexCache;
    private final ScheduledExecutorService maintenanceExecutor;
    private static final Logger LOG = LoggerFactory.getLogger(BlobStore.class);
    final AtomicBoolean cleanupInProgress = new AtomicBoolean(false);

    public BlobStore(@NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, @NonNull PhysicalIOConfiguration configuration, @NonNull Metrics metrics, @NonNull ExecutorService threadPool) {
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        if (threadPool == null) {
            throw new NullPointerException("threadPool is marked non-null but is null");
        }
        this.objectClient = objectClient;
        this.telemetry = telemetry;
        this.metrics = metrics;
        this.blobMap = Collections.synchronizedMap(new LinkedHashMap());
        this.indexCache = new BlobStoreIndexCache(configuration);
        this.maintenanceExecutor = Executors.newSingleThreadScheduledExecutor(cleanupTask -> {
            Thread cleanupThread = new Thread(cleanupTask);
            cleanupThread.setDaemon(true);
            cleanupThread.setPriority(1);
            return cleanupThread;
        });
        this.configuration = configuration;
        this.threadPool = threadPool;
    }

    public void schedulePeriodicCleanup() {
        this.maintenanceExecutor.scheduleAtFixedRate(this::scheduleCleanupIfNotRunning, this.configuration.getMemoryCleanupFrequencyMilliseconds(), this.configuration.getMemoryCleanupFrequencyMilliseconds(), TimeUnit.MILLISECONDS);
    }

    void scheduleCleanupIfNotRunning() {
        if (this.metrics.get(MetricKey.MEMORY_USAGE) > 0L && this.cleanupInProgress.compareAndSet(false, true)) {
            try {
                this.asyncCleanup();
            }
            catch (Exception ex) {
                LOG.debug("Error during cleanup", (Throwable)ex);
            }
            finally {
                this.cleanupInProgress.set(false);
            }
        }
    }

    void asyncCleanup() {
        LOG.debug("Current memory usage of blobMap in bytes before eviction is: {}", (Object)this.metrics.get(MetricKey.MEMORY_USAGE));
        this.blobMap.forEach((k, v) -> v.asyncCleanup());
        LOG.debug("Current memory usage of blobMap in bytes after eviction is: {}", (Object)this.metrics.get(MetricKey.MEMORY_USAGE));
    }

    public Blob get(ObjectKey objectKey, ObjectMetadata metadata, OpenStreamInformation openStreamInformation) {
        return this.blobMap.computeIfAbsent(objectKey, uri -> new Blob((ObjectKey)uri, metadata, new BlockManager(objectKey, this.objectClient, metadata, this.telemetry, this.configuration, this.metrics, this.indexCache, openStreamInformation, this.threadPool), this.telemetry));
    }

    public boolean evictKey(ObjectKey objectKey) {
        return this.blobMap.remove(objectKey) != null;
    }

    public int blobCount() {
        return this.blobMap.size();
    }

    @Override
    public void close() {
        try {
            if (this.maintenanceExecutor != null) {
                this.maintenanceExecutor.shutdownNow();
            }
            this.blobMap.forEach((k, v) -> v.close());
            this.indexCache.cleanUp();
        }
        catch (Exception e) {
            LOG.error("Error while closing BlobStore", (Throwable)e);
        }
    }

    @Generated
    public Metrics getMetrics() {
        return this.metrics;
    }
}

