/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Block;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockManager;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanState;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class Blob
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Blob.class);
    private static final String OPERATION_EXECUTE = "blob.execute";
    private final ObjectKey objectKey;
    private final BlockManager blockManager;
    private final ObjectMetadata metadata;
    private final Telemetry telemetry;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public Blob(@NonNull ObjectKey objectKey, @NonNull ObjectMetadata metadata, @NonNull BlockManager blockManager, @NonNull Telemetry telemetry) {
        if (objectKey == null) {
            throw new NullPointerException("objectKey is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (blockManager == null) {
            throw new NullPointerException("blockManager is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        this.objectKey = objectKey;
        this.metadata = metadata;
        this.blockManager = blockManager;
        this.telemetry = telemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long pos) throws IOException {
        Preconditions.checkArgument(pos >= 0L, "`pos` must be non-negative");
        try {
            this.lock.readLock().lock();
            this.blockManager.makePositionAvailable(pos, ReadMode.SYNC);
            Optional<Block> block = this.blockManager.getBlock(pos);
            int n = block.orElseThrow(() -> new IllegalStateException(String.format("This block object key %s (for position %s) should have been available.", this.objectKey.getS3URI(), pos))).read(pos);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len, long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        try {
            int numBytesRead;
            int bytesRead;
            this.lock.readLock().lock();
            this.blockManager.makeRangeAvailable(pos, len, ReadMode.SYNC);
            long nextPosition = pos;
            for (numBytesRead = 0; numBytesRead < len && nextPosition < this.contentLength(); numBytesRead += bytesRead, nextPosition += (long)bytesRead) {
                long nextPositionFinal = nextPosition;
                Block nextBlock = this.blockManager.getBlock(nextPosition).orElseThrow(() -> new IllegalStateException(String.format("This block object key %s (for position %s) should have been available.", this.objectKey.getS3URI(), nextPositionFinal)));
                bytesRead = nextBlock.read(buf, off + numBytesRead, len - numBytesRead, nextPosition);
                if (bytesRead != -1) continue;
                int n = numBytesRead;
                return n;
            }
            int n = numBytesRead;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public IOPlanExecution execute(IOPlan plan, ReadMode readMode) throws IOException {
        return this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_EXECUTE)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.ioPlan(plan))).build(), () -> {
            try {
                for (Range range : plan.getPrefetchRanges()) {
                    this.blockManager.makeRangeAvailable(range.getStart(), range.getLength(), readMode);
                }
                return IOPlanExecution.builder().state(IOPlanState.SUBMITTED).build();
            }
            catch (Exception e) {
                LOG.error("Failed to submit IOPlan to PhysicalIO", (Throwable)e);
                return IOPlanExecution.builder().state(IOPlanState.FAILED).build();
            }
        });
    }

    public final void asyncCleanup() {
        if (this.blockManager.isBlockStoreEmpty()) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            this.blockManager.cleanUp();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private long contentLength() {
        return this.metadata.getContentLength();
    }

    @Override
    public void close() {
        this.blockManager.close();
    }
}

