/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public class PhysicalIOConfiguration {
    private static final long DEFAULT_MEMORY_CAPACITY_BYTES = 0x80000000L;
    private static final long DEFAULT_CACHE_DATA_TIMEOUT_MILLISECONDS = 1000L;
    private static final long DEFAULT_METADATA_STORE_TTL_MILLISECONDS = 86400000L;
    private static final int DEFAULT_CAPACITY_METADATA_STORE = 5000;
    private static final boolean DEFAULT_USE_SINGLE_CACHE = true;
    private static final long DEFAULT_BLOCK_SIZE_BYTES = 0x800000L;
    private static final long DEFAULT_READ_AHEAD_BYTES = 65536L;
    private static final double DEFAULT_SEQUENTIAL_PREFETCH_BASE = 2.0;
    private static final double DEFAULT_SEQUENTIAL_PREFETCH_SPEED = 1.0;
    private static final long DEFAULT_SEQUENTIAL_PREFETCH_MAX_SIZE = 0x8000000L;
    private static final long DEFAULT_BLOCK_READ_TIMEOUT = 30000L;
    private static final int DEFAULT_BLOCK_READ_RETRY_COUNT = 20;
    private static final int DEFAULT_MEMORY_CLEANUP_FREQUENCY_MILLISECONDS = 5000;
    private static final boolean DEFAULT_SMALL_OBJECTS_PREFETCHING_ENABLED = true;
    private static final long DEFAULT_SMALL_OBJECT_SIZE_THRESHOLD = 0x800000L;
    private static final int DEFAULT_THREAD_POOL_SIZE = 96;
    private static final long DEFAULT_READ_BUFFER_SIZE = 131072L;
    private static final long DEFAULT_TARGET_REQUEST_SIZE = 0x800000L;
    private static final double DEFAULT_REQUEST_TOLERANCE_RATIO = 1.4;
    private long memoryCapacityBytes;
    private static final String MEMORY_CAPACITY_BYTES_KEY = "max.memory.limit";
    private int memoryCleanupFrequencyMilliseconds;
    private static final String MEMORY_CLEANUP_FREQUENCY_MILLISECONDS_KEY = "memory.cleanup.frequency";
    private long cacheDataTimeoutMilliseconds;
    private static final String CACHE_DATA_TIMEOUT_MILLISECONDS_KEY = "cache.timeout";
    private long metadataCacheTtlMilliseconds;
    private static final String METADATA_CACHE_TTL_MILLISECONDS_KEY = "metadatastore.ttl";
    private int metadataStoreCapacity;
    private static final String METADATA_STORE_CAPACITY_KEY = "metadatastore.capacity";
    private long blockSizeBytes;
    private static final String BLOCK_SIZE_BYTES_KEY = "blocksizebytes";
    private long readAheadBytes;
    private static final String READ_AHEAD_BYTES_KEY = "readaheadbytes";
    private double sequentialPrefetchBase;
    private static final String SEQUENTIAL_PREFETCH_BASE_KEY = "sequentialprefetch.base";
    private double sequentialPrefetchSpeed;
    private static final String SEQUENTIAL_PREFETCH_SPEED_KEY = "sequentialprefetch.speed";
    private long sequentialPrefetchMaxSize;
    private static final String SEQUENTIAL_PREFETCH_MAX_SIZE_KEY = "sequentialprefetch.max.size";
    private long blockReadTimeout;
    private static final String BLOCK_READ_TIMEOUT_KEY = "blockreadtimeout";
    private int blockReadRetryCount;
    private static final String BLOCK_READ_RETRY_COUNT_KEY = "blockreadretrycount";
    private boolean smallObjectsPrefetchingEnabled;
    private static final String SMALL_OBJECTS_PREFETCHING_ENABLED_KEY = "small.objects.prefetching.enabled";
    private long smallObjectSizeThreshold;
    private static final String SMALL_OBJECT_SIZE_THRESHOLD_KEY = "small.object.size.threshold";
    private static final String THREAD_POOL_SIZE_KEY = "thread.pool.size";
    private int threadPoolSize;
    private static final String READ_BUFFER_SIZE_KEY = "readbuffersize";
    private long readBufferSize;
    private long targetRequestSize;
    private static final String TARGET_REQUEST_SIZE_KEY = "target.request.size";
    private double requestToleranceRatio;
    private static final String REQUEST_TOLERANCE_RATIO_KEY = "request.tolerance.ratio";
    public static final PhysicalIOConfiguration DEFAULT = PhysicalIOConfiguration.builder().build();

    public static PhysicalIOConfiguration fromConfiguration(ConnectorConfiguration configuration) {
        return PhysicalIOConfiguration.builder().memoryCapacityBytes(configuration.getLong(MEMORY_CAPACITY_BYTES_KEY, 0x80000000L)).memoryCleanupFrequencyMilliseconds(configuration.getInt(MEMORY_CLEANUP_FREQUENCY_MILLISECONDS_KEY, 5000)).cacheDataTimeoutMilliseconds(configuration.getLong(CACHE_DATA_TIMEOUT_MILLISECONDS_KEY, 1000L)).metadataCacheTtlMilliseconds(configuration.getLong(METADATA_CACHE_TTL_MILLISECONDS_KEY, 86400000L)).metadataStoreCapacity(configuration.getInt(METADATA_STORE_CAPACITY_KEY, 5000)).blockSizeBytes(configuration.getLong(BLOCK_SIZE_BYTES_KEY, 0x800000L)).readAheadBytes(configuration.getLong(READ_AHEAD_BYTES_KEY, 65536L)).sequentialPrefetchBase(configuration.getDouble(SEQUENTIAL_PREFETCH_BASE_KEY, 2.0)).sequentialPrefetchSpeed(configuration.getDouble(SEQUENTIAL_PREFETCH_SPEED_KEY, 1.0)).sequentialPrefetchMaxSize(configuration.getLong(SEQUENTIAL_PREFETCH_MAX_SIZE_KEY, 0x8000000L)).blockReadTimeout(configuration.getLong(BLOCK_READ_TIMEOUT_KEY, 30000L)).blockReadRetryCount(configuration.getInt(BLOCK_READ_RETRY_COUNT_KEY, 20)).smallObjectsPrefetchingEnabled(configuration.getBoolean(SMALL_OBJECTS_PREFETCHING_ENABLED_KEY, true)).smallObjectSizeThreshold(configuration.getLong(SMALL_OBJECT_SIZE_THRESHOLD_KEY, 0x800000L)).threadPoolSize(configuration.getInt(THREAD_POOL_SIZE_KEY, 96)).readBufferSize(configuration.getLong(READ_BUFFER_SIZE_KEY, 131072L)).targetRequestSize(configuration.getLong(TARGET_REQUEST_SIZE_KEY, 0x800000L)).requestToleranceRatio(configuration.getDouble(REQUEST_TOLERANCE_RATIO_KEY, 1.4)).build();
    }

    private PhysicalIOConfiguration(long memoryCapacityBytes, int memoryCleanupFrequencyMilliseconds, long cacheDataTimeoutMilliseconds, long metadataCacheTtlMilliseconds, int metadataStoreCapacity, long blockSizeBytes, long readAheadBytes, double sequentialPrefetchBase, double sequentialPrefetchSpeed, long sequentialPrefetchMaxSize, long blockReadTimeout, int blockReadRetryCount, boolean smallObjectsPrefetchingEnabled, long smallObjectSizeThreshold, int threadPoolSize, long readBufferSize, long targetRequestSize, double requestToleranceRatio) {
        Preconditions.checkArgument(memoryCapacityBytes > 0L, "`memoryCapacityBytes` must be positive");
        Preconditions.checkArgument(memoryCleanupFrequencyMilliseconds > 0, "`memoryCleanupFrequencyMilliseconds` must be positive");
        Preconditions.checkArgument(cacheDataTimeoutMilliseconds > 0L, "`cacheDataTimeoutMilliseconds` must be positive");
        Preconditions.checkArgument(metadataCacheTtlMilliseconds >= 0L, "`metadataCacheTTLMilliseconds` must be positive");
        Preconditions.checkArgument(metadataStoreCapacity > 0, "`metadataStoreCapacity` must be positive");
        Preconditions.checkArgument(blockSizeBytes > 0L, "`blockSizeBytes` must be positive");
        Preconditions.checkArgument(readAheadBytes > 0L, "`readAheadLengthBytes` must be positive");
        Preconditions.checkArgument(sequentialPrefetchBase > 0.0, "`sequentialPrefetchBase` must be positive");
        Preconditions.checkArgument(sequentialPrefetchSpeed > 0.0, "`sequentialPrefetchSpeed` must be positive");
        Preconditions.checkArgument(sequentialPrefetchMaxSize > 0L, "`sequentialPrefetchMaxSize` must be positive");
        Preconditions.checkArgument(blockReadTimeout > 0L, "`blockReadTimeout` must be positive");
        Preconditions.checkArgument(blockReadRetryCount >= 0, "`blockReadRetryCount` must be non-negative");
        Preconditions.checkArgument(smallObjectSizeThreshold > 0L, "`smallObjectSizeThreshold` must be positive");
        Preconditions.checkNotNull(threadPoolSize > 0, "`threadPoolSize` must be positive");
        Preconditions.checkArgument(readBufferSize > 0L, "`readBufferSize` must be positive");
        Preconditions.checkArgument(targetRequestSize > 0L, "`targetRequestSize` must be positive");
        Preconditions.checkArgument(requestToleranceRatio >= 1.0, "`requestToleranceRatio` must be greater than or equal than 1");
        this.memoryCapacityBytes = memoryCapacityBytes;
        this.memoryCleanupFrequencyMilliseconds = memoryCleanupFrequencyMilliseconds;
        this.cacheDataTimeoutMilliseconds = cacheDataTimeoutMilliseconds;
        this.metadataCacheTtlMilliseconds = metadataCacheTtlMilliseconds;
        this.metadataStoreCapacity = metadataStoreCapacity;
        this.blockSizeBytes = blockSizeBytes;
        this.readAheadBytes = readAheadBytes;
        this.sequentialPrefetchBase = sequentialPrefetchBase;
        this.sequentialPrefetchSpeed = sequentialPrefetchSpeed;
        this.sequentialPrefetchMaxSize = sequentialPrefetchMaxSize;
        this.blockReadTimeout = blockReadTimeout;
        this.blockReadRetryCount = blockReadRetryCount;
        this.smallObjectsPrefetchingEnabled = smallObjectsPrefetchingEnabled;
        this.smallObjectSizeThreshold = smallObjectSizeThreshold;
        this.threadPoolSize = threadPoolSize;
        this.readBufferSize = readBufferSize;
        this.targetRequestSize = targetRequestSize;
        this.requestToleranceRatio = requestToleranceRatio;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PhysicalIO configuration:\n");
        builder.append("\tmemoryCapacityBytes: " + this.memoryCapacityBytes + "\n");
        builder.append("\tmemoryCleanupFrequencyMilliseconds: " + this.memoryCleanupFrequencyMilliseconds + "\n");
        builder.append("\tcacheDataTimeoutMilliseconds: " + this.cacheDataTimeoutMilliseconds + "\n");
        builder.append("\tmetadataCacheTtlMilliseconds: " + this.metadataCacheTtlMilliseconds + "\n");
        builder.append("\tmetadataStoreCapacity: " + this.metadataStoreCapacity + "\n");
        builder.append("\tblockSizeBytes: " + this.blockSizeBytes + "\n");
        builder.append("\treadAheadBytes: " + this.readAheadBytes + "\n");
        builder.append("\tsequentialPrefetchBase: " + this.sequentialPrefetchBase + "\n");
        builder.append("\tsequentialPrefetchSpeed: " + this.sequentialPrefetchSpeed + "\n");
        builder.append("\tsequentialPrefetchMaxSize: " + this.sequentialPrefetchMaxSize + "\n");
        builder.append("\tblockReadTimeout: " + this.blockReadTimeout + "\n");
        builder.append("\tblockReadRetryCount: " + this.blockReadRetryCount + "\n");
        builder.append("\tsmallObjectsPrefetchingEnabled: " + this.smallObjectsPrefetchingEnabled + "\n");
        builder.append("\tsmallObjectSizeThreshold: " + this.smallObjectSizeThreshold + "\n");
        builder.append("\tthreadPoolSize: " + this.threadPoolSize + "\n");
        builder.append("\treadBufferSize: " + this.readBufferSize + "\n");
        builder.append("\ttargetRequestSize: " + this.targetRequestSize + "\n");
        builder.append("\trequestToleranceRatio: " + this.requestToleranceRatio + "\n");
        return builder.toString();
    }

    @Generated
    private static long $default$memoryCapacityBytes() {
        return 0x80000000L;
    }

    @Generated
    private static int $default$memoryCleanupFrequencyMilliseconds() {
        return 5000;
    }

    @Generated
    private static long $default$cacheDataTimeoutMilliseconds() {
        return 1000L;
    }

    @Generated
    private static long $default$metadataCacheTtlMilliseconds() {
        return 86400000L;
    }

    @Generated
    private static int $default$metadataStoreCapacity() {
        return 5000;
    }

    @Generated
    private static long $default$blockSizeBytes() {
        return 0x800000L;
    }

    @Generated
    private static long $default$readAheadBytes() {
        return 65536L;
    }

    @Generated
    private static double $default$sequentialPrefetchBase() {
        return 2.0;
    }

    @Generated
    private static double $default$sequentialPrefetchSpeed() {
        return 1.0;
    }

    @Generated
    private static long $default$sequentialPrefetchMaxSize() {
        return 0x8000000L;
    }

    @Generated
    private static long $default$blockReadTimeout() {
        return 30000L;
    }

    @Generated
    private static int $default$blockReadRetryCount() {
        return 20;
    }

    @Generated
    private static boolean $default$smallObjectsPrefetchingEnabled() {
        return true;
    }

    @Generated
    private static long $default$smallObjectSizeThreshold() {
        return 0x800000L;
    }

    @Generated
    private static int $default$threadPoolSize() {
        return 96;
    }

    @Generated
    private static long $default$readBufferSize() {
        return 131072L;
    }

    @Generated
    private static long $default$targetRequestSize() {
        return 0x800000L;
    }

    @Generated
    private static double $default$requestToleranceRatio() {
        return 1.4;
    }

    @Generated
    public static PhysicalIOConfigurationBuilder builder() {
        return new PhysicalIOConfigurationBuilder();
    }

    @Generated
    public long getMemoryCapacityBytes() {
        return this.memoryCapacityBytes;
    }

    @Generated
    public int getMemoryCleanupFrequencyMilliseconds() {
        return this.memoryCleanupFrequencyMilliseconds;
    }

    @Generated
    public long getCacheDataTimeoutMilliseconds() {
        return this.cacheDataTimeoutMilliseconds;
    }

    @Generated
    public long getMetadataCacheTtlMilliseconds() {
        return this.metadataCacheTtlMilliseconds;
    }

    @Generated
    public int getMetadataStoreCapacity() {
        return this.metadataStoreCapacity;
    }

    @Generated
    public long getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    @Generated
    public long getReadAheadBytes() {
        return this.readAheadBytes;
    }

    @Generated
    public double getSequentialPrefetchBase() {
        return this.sequentialPrefetchBase;
    }

    @Generated
    public double getSequentialPrefetchSpeed() {
        return this.sequentialPrefetchSpeed;
    }

    @Generated
    public long getSequentialPrefetchMaxSize() {
        return this.sequentialPrefetchMaxSize;
    }

    @Generated
    public long getBlockReadTimeout() {
        return this.blockReadTimeout;
    }

    @Generated
    public int getBlockReadRetryCount() {
        return this.blockReadRetryCount;
    }

    @Generated
    public boolean isSmallObjectsPrefetchingEnabled() {
        return this.smallObjectsPrefetchingEnabled;
    }

    @Generated
    public long getSmallObjectSizeThreshold() {
        return this.smallObjectSizeThreshold;
    }

    @Generated
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Generated
    public long getReadBufferSize() {
        return this.readBufferSize;
    }

    @Generated
    public long getTargetRequestSize() {
        return this.targetRequestSize;
    }

    @Generated
    public double getRequestToleranceRatio() {
        return this.requestToleranceRatio;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalIOConfiguration)) {
            return false;
        }
        PhysicalIOConfiguration other = (PhysicalIOConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMemoryCapacityBytes() != other.getMemoryCapacityBytes()) {
            return false;
        }
        if (this.getMemoryCleanupFrequencyMilliseconds() != other.getMemoryCleanupFrequencyMilliseconds()) {
            return false;
        }
        if (this.getCacheDataTimeoutMilliseconds() != other.getCacheDataTimeoutMilliseconds()) {
            return false;
        }
        if (this.getMetadataCacheTtlMilliseconds() != other.getMetadataCacheTtlMilliseconds()) {
            return false;
        }
        if (this.getMetadataStoreCapacity() != other.getMetadataStoreCapacity()) {
            return false;
        }
        if (this.getBlockSizeBytes() != other.getBlockSizeBytes()) {
            return false;
        }
        if (this.getReadAheadBytes() != other.getReadAheadBytes()) {
            return false;
        }
        if (Double.compare(this.getSequentialPrefetchBase(), other.getSequentialPrefetchBase()) != 0) {
            return false;
        }
        if (Double.compare(this.getSequentialPrefetchSpeed(), other.getSequentialPrefetchSpeed()) != 0) {
            return false;
        }
        if (this.getSequentialPrefetchMaxSize() != other.getSequentialPrefetchMaxSize()) {
            return false;
        }
        if (this.getBlockReadTimeout() != other.getBlockReadTimeout()) {
            return false;
        }
        if (this.getBlockReadRetryCount() != other.getBlockReadRetryCount()) {
            return false;
        }
        if (this.isSmallObjectsPrefetchingEnabled() != other.isSmallObjectsPrefetchingEnabled()) {
            return false;
        }
        if (this.getSmallObjectSizeThreshold() != other.getSmallObjectSizeThreshold()) {
            return false;
        }
        if (this.getThreadPoolSize() != other.getThreadPoolSize()) {
            return false;
        }
        if (this.getReadBufferSize() != other.getReadBufferSize()) {
            return false;
        }
        if (this.getTargetRequestSize() != other.getTargetRequestSize()) {
            return false;
        }
        return Double.compare(this.getRequestToleranceRatio(), other.getRequestToleranceRatio()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PhysicalIOConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $memoryCapacityBytes = this.getMemoryCapacityBytes();
        result = result * 59 + (int)($memoryCapacityBytes >>> 32 ^ $memoryCapacityBytes);
        result = result * 59 + this.getMemoryCleanupFrequencyMilliseconds();
        long $cacheDataTimeoutMilliseconds = this.getCacheDataTimeoutMilliseconds();
        result = result * 59 + (int)($cacheDataTimeoutMilliseconds >>> 32 ^ $cacheDataTimeoutMilliseconds);
        long $metadataCacheTtlMilliseconds = this.getMetadataCacheTtlMilliseconds();
        result = result * 59 + (int)($metadataCacheTtlMilliseconds >>> 32 ^ $metadataCacheTtlMilliseconds);
        result = result * 59 + this.getMetadataStoreCapacity();
        long $blockSizeBytes = this.getBlockSizeBytes();
        result = result * 59 + (int)($blockSizeBytes >>> 32 ^ $blockSizeBytes);
        long $readAheadBytes = this.getReadAheadBytes();
        result = result * 59 + (int)($readAheadBytes >>> 32 ^ $readAheadBytes);
        long $sequentialPrefetchBase = Double.doubleToLongBits(this.getSequentialPrefetchBase());
        result = result * 59 + (int)($sequentialPrefetchBase >>> 32 ^ $sequentialPrefetchBase);
        long $sequentialPrefetchSpeed = Double.doubleToLongBits(this.getSequentialPrefetchSpeed());
        result = result * 59 + (int)($sequentialPrefetchSpeed >>> 32 ^ $sequentialPrefetchSpeed);
        long $sequentialPrefetchMaxSize = this.getSequentialPrefetchMaxSize();
        result = result * 59 + (int)($sequentialPrefetchMaxSize >>> 32 ^ $sequentialPrefetchMaxSize);
        long $blockReadTimeout = this.getBlockReadTimeout();
        result = result * 59 + (int)($blockReadTimeout >>> 32 ^ $blockReadTimeout);
        result = result * 59 + this.getBlockReadRetryCount();
        result = result * 59 + (this.isSmallObjectsPrefetchingEnabled() ? 79 : 97);
        long $smallObjectSizeThreshold = this.getSmallObjectSizeThreshold();
        result = result * 59 + (int)($smallObjectSizeThreshold >>> 32 ^ $smallObjectSizeThreshold);
        result = result * 59 + this.getThreadPoolSize();
        long $readBufferSize = this.getReadBufferSize();
        result = result * 59 + (int)($readBufferSize >>> 32 ^ $readBufferSize);
        long $targetRequestSize = this.getTargetRequestSize();
        result = result * 59 + (int)($targetRequestSize >>> 32 ^ $targetRequestSize);
        long $requestToleranceRatio = Double.doubleToLongBits(this.getRequestToleranceRatio());
        result = result * 59 + (int)($requestToleranceRatio >>> 32 ^ $requestToleranceRatio);
        return result;
    }

    @Generated
    public static class PhysicalIOConfigurationBuilder {
        @Generated
        private boolean memoryCapacityBytes$set;
        @Generated
        private long memoryCapacityBytes$value;
        @Generated
        private boolean memoryCleanupFrequencyMilliseconds$set;
        @Generated
        private int memoryCleanupFrequencyMilliseconds$value;
        @Generated
        private boolean cacheDataTimeoutMilliseconds$set;
        @Generated
        private long cacheDataTimeoutMilliseconds$value;
        @Generated
        private boolean metadataCacheTtlMilliseconds$set;
        @Generated
        private long metadataCacheTtlMilliseconds$value;
        @Generated
        private boolean metadataStoreCapacity$set;
        @Generated
        private int metadataStoreCapacity$value;
        @Generated
        private boolean blockSizeBytes$set;
        @Generated
        private long blockSizeBytes$value;
        @Generated
        private boolean readAheadBytes$set;
        @Generated
        private long readAheadBytes$value;
        @Generated
        private boolean sequentialPrefetchBase$set;
        @Generated
        private double sequentialPrefetchBase$value;
        @Generated
        private boolean sequentialPrefetchSpeed$set;
        @Generated
        private double sequentialPrefetchSpeed$value;
        @Generated
        private boolean sequentialPrefetchMaxSize$set;
        @Generated
        private long sequentialPrefetchMaxSize$value;
        @Generated
        private boolean blockReadTimeout$set;
        @Generated
        private long blockReadTimeout$value;
        @Generated
        private boolean blockReadRetryCount$set;
        @Generated
        private int blockReadRetryCount$value;
        @Generated
        private boolean smallObjectsPrefetchingEnabled$set;
        @Generated
        private boolean smallObjectsPrefetchingEnabled$value;
        @Generated
        private boolean smallObjectSizeThreshold$set;
        @Generated
        private long smallObjectSizeThreshold$value;
        @Generated
        private boolean threadPoolSize$set;
        @Generated
        private int threadPoolSize$value;
        @Generated
        private boolean readBufferSize$set;
        @Generated
        private long readBufferSize$value;
        @Generated
        private boolean targetRequestSize$set;
        @Generated
        private long targetRequestSize$value;
        @Generated
        private boolean requestToleranceRatio$set;
        @Generated
        private double requestToleranceRatio$value;
        @Generated
        private long memoryCapacityBytes;
        @Generated
        private int memoryCleanupFrequencyMilliseconds;
        @Generated
        private long cacheDataTimeoutMilliseconds;
        @Generated
        private long metadataCacheTtlMilliseconds;
        @Generated
        private int metadataStoreCapacity;
        @Generated
        private long blockSizeBytes;
        @Generated
        private long readAheadBytes;
        @Generated
        private double sequentialPrefetchBase;
        @Generated
        private double sequentialPrefetchSpeed;
        @Generated
        private long sequentialPrefetchMaxSize;
        @Generated
        private long blockReadTimeout;
        @Generated
        private int blockReadRetryCount;
        @Generated
        private boolean smallObjectsPrefetchingEnabled;
        @Generated
        private long smallObjectSizeThreshold;
        @Generated
        private int threadPoolSize;
        @Generated
        private long readBufferSize;
        @Generated
        private long targetRequestSize;
        @Generated
        private double requestToleranceRatio;

        @Generated
        PhysicalIOConfigurationBuilder() {
        }

        @Generated
        public PhysicalIOConfigurationBuilder memoryCapacityBytes(long memoryCapacityBytes) {
            this.memoryCapacityBytes$value = memoryCapacityBytes;
            this.memoryCapacityBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder memoryCleanupFrequencyMilliseconds(int memoryCleanupFrequencyMilliseconds) {
            this.memoryCleanupFrequencyMilliseconds$value = memoryCleanupFrequencyMilliseconds;
            this.memoryCleanupFrequencyMilliseconds$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder cacheDataTimeoutMilliseconds(long cacheDataTimeoutMilliseconds) {
            this.cacheDataTimeoutMilliseconds$value = cacheDataTimeoutMilliseconds;
            this.cacheDataTimeoutMilliseconds$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder metadataCacheTtlMilliseconds(long metadataCacheTtlMilliseconds) {
            this.metadataCacheTtlMilliseconds$value = metadataCacheTtlMilliseconds;
            this.metadataCacheTtlMilliseconds$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder metadataStoreCapacity(int metadataStoreCapacity) {
            this.metadataStoreCapacity$value = metadataStoreCapacity;
            this.metadataStoreCapacity$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder blockSizeBytes(long blockSizeBytes) {
            this.blockSizeBytes$value = blockSizeBytes;
            this.blockSizeBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder readAheadBytes(long readAheadBytes) {
            this.readAheadBytes$value = readAheadBytes;
            this.readAheadBytes$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder sequentialPrefetchBase(double sequentialPrefetchBase) {
            this.sequentialPrefetchBase$value = sequentialPrefetchBase;
            this.sequentialPrefetchBase$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder sequentialPrefetchSpeed(double sequentialPrefetchSpeed) {
            this.sequentialPrefetchSpeed$value = sequentialPrefetchSpeed;
            this.sequentialPrefetchSpeed$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder sequentialPrefetchMaxSize(long sequentialPrefetchMaxSize) {
            this.sequentialPrefetchMaxSize$value = sequentialPrefetchMaxSize;
            this.sequentialPrefetchMaxSize$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder blockReadTimeout(long blockReadTimeout) {
            this.blockReadTimeout$value = blockReadTimeout;
            this.blockReadTimeout$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder blockReadRetryCount(int blockReadRetryCount) {
            this.blockReadRetryCount$value = blockReadRetryCount;
            this.blockReadRetryCount$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder smallObjectsPrefetchingEnabled(boolean smallObjectsPrefetchingEnabled) {
            this.smallObjectsPrefetchingEnabled$value = smallObjectsPrefetchingEnabled;
            this.smallObjectsPrefetchingEnabled$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder smallObjectSizeThreshold(long smallObjectSizeThreshold) {
            this.smallObjectSizeThreshold$value = smallObjectSizeThreshold;
            this.smallObjectSizeThreshold$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize$value = threadPoolSize;
            this.threadPoolSize$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder readBufferSize(long readBufferSize) {
            this.readBufferSize$value = readBufferSize;
            this.readBufferSize$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder targetRequestSize(long targetRequestSize) {
            this.targetRequestSize$value = targetRequestSize;
            this.targetRequestSize$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfigurationBuilder requestToleranceRatio(double requestToleranceRatio) {
            this.requestToleranceRatio$value = requestToleranceRatio;
            this.requestToleranceRatio$set = true;
            return this;
        }

        @Generated
        public PhysicalIOConfiguration build() {
            long memoryCapacityBytes$value = this.memoryCapacityBytes$value;
            if (!this.memoryCapacityBytes$set) {
                memoryCapacityBytes$value = PhysicalIOConfiguration.$default$memoryCapacityBytes();
            }
            int memoryCleanupFrequencyMilliseconds$value = this.memoryCleanupFrequencyMilliseconds$value;
            if (!this.memoryCleanupFrequencyMilliseconds$set) {
                memoryCleanupFrequencyMilliseconds$value = PhysicalIOConfiguration.$default$memoryCleanupFrequencyMilliseconds();
            }
            long cacheDataTimeoutMilliseconds$value = this.cacheDataTimeoutMilliseconds$value;
            if (!this.cacheDataTimeoutMilliseconds$set) {
                cacheDataTimeoutMilliseconds$value = PhysicalIOConfiguration.$default$cacheDataTimeoutMilliseconds();
            }
            long metadataCacheTtlMilliseconds$value = this.metadataCacheTtlMilliseconds$value;
            if (!this.metadataCacheTtlMilliseconds$set) {
                metadataCacheTtlMilliseconds$value = PhysicalIOConfiguration.$default$metadataCacheTtlMilliseconds();
            }
            int metadataStoreCapacity$value = this.metadataStoreCapacity$value;
            if (!this.metadataStoreCapacity$set) {
                metadataStoreCapacity$value = PhysicalIOConfiguration.$default$metadataStoreCapacity();
            }
            long blockSizeBytes$value = this.blockSizeBytes$value;
            if (!this.blockSizeBytes$set) {
                blockSizeBytes$value = PhysicalIOConfiguration.$default$blockSizeBytes();
            }
            long readAheadBytes$value = this.readAheadBytes$value;
            if (!this.readAheadBytes$set) {
                readAheadBytes$value = PhysicalIOConfiguration.$default$readAheadBytes();
            }
            double sequentialPrefetchBase$value = this.sequentialPrefetchBase$value;
            if (!this.sequentialPrefetchBase$set) {
                sequentialPrefetchBase$value = PhysicalIOConfiguration.$default$sequentialPrefetchBase();
            }
            double sequentialPrefetchSpeed$value = this.sequentialPrefetchSpeed$value;
            if (!this.sequentialPrefetchSpeed$set) {
                sequentialPrefetchSpeed$value = PhysicalIOConfiguration.$default$sequentialPrefetchSpeed();
            }
            long sequentialPrefetchMaxSize$value = this.sequentialPrefetchMaxSize$value;
            if (!this.sequentialPrefetchMaxSize$set) {
                sequentialPrefetchMaxSize$value = PhysicalIOConfiguration.$default$sequentialPrefetchMaxSize();
            }
            long blockReadTimeout$value = this.blockReadTimeout$value;
            if (!this.blockReadTimeout$set) {
                blockReadTimeout$value = PhysicalIOConfiguration.$default$blockReadTimeout();
            }
            int blockReadRetryCount$value = this.blockReadRetryCount$value;
            if (!this.blockReadRetryCount$set) {
                blockReadRetryCount$value = PhysicalIOConfiguration.$default$blockReadRetryCount();
            }
            boolean smallObjectsPrefetchingEnabled$value = this.smallObjectsPrefetchingEnabled$value;
            if (!this.smallObjectsPrefetchingEnabled$set) {
                smallObjectsPrefetchingEnabled$value = PhysicalIOConfiguration.$default$smallObjectsPrefetchingEnabled();
            }
            long smallObjectSizeThreshold$value = this.smallObjectSizeThreshold$value;
            if (!this.smallObjectSizeThreshold$set) {
                smallObjectSizeThreshold$value = PhysicalIOConfiguration.$default$smallObjectSizeThreshold();
            }
            int threadPoolSize$value = this.threadPoolSize$value;
            if (!this.threadPoolSize$set) {
                threadPoolSize$value = PhysicalIOConfiguration.$default$threadPoolSize();
            }
            long readBufferSize$value = this.readBufferSize$value;
            if (!this.readBufferSize$set) {
                readBufferSize$value = PhysicalIOConfiguration.$default$readBufferSize();
            }
            long targetRequestSize$value = this.targetRequestSize$value;
            if (!this.targetRequestSize$set) {
                targetRequestSize$value = PhysicalIOConfiguration.$default$targetRequestSize();
            }
            double requestToleranceRatio$value = this.requestToleranceRatio$value;
            if (!this.requestToleranceRatio$set) {
                requestToleranceRatio$value = PhysicalIOConfiguration.$default$requestToleranceRatio();
            }
            return new PhysicalIOConfiguration(memoryCapacityBytes$value, memoryCleanupFrequencyMilliseconds$value, cacheDataTimeoutMilliseconds$value, metadataCacheTtlMilliseconds$value, metadataStoreCapacity$value, blockSizeBytes$value, readAheadBytes$value, sequentialPrefetchBase$value, sequentialPrefetchSpeed$value, sequentialPrefetchMaxSize$value, blockReadTimeout$value, blockReadRetryCount$value, smallObjectsPrefetchingEnabled$value, smallObjectSizeThreshold$value, threadPoolSize$value, readBufferSize$value, targetRequestSize$value, requestToleranceRatio$value);
        }

        @Generated
        public String toString() {
            return "PhysicalIOConfiguration.PhysicalIOConfigurationBuilder(memoryCapacityBytes$value=" + this.memoryCapacityBytes$value + ", memoryCleanupFrequencyMilliseconds$value=" + this.memoryCleanupFrequencyMilliseconds$value + ", cacheDataTimeoutMilliseconds$value=" + this.cacheDataTimeoutMilliseconds$value + ", metadataCacheTtlMilliseconds$value=" + this.metadataCacheTtlMilliseconds$value + ", metadataStoreCapacity$value=" + this.metadataStoreCapacity$value + ", blockSizeBytes$value=" + this.blockSizeBytes$value + ", readAheadBytes$value=" + this.readAheadBytes$value + ", sequentialPrefetchBase$value=" + this.sequentialPrefetchBase$value + ", sequentialPrefetchSpeed$value=" + this.sequentialPrefetchSpeed$value + ", sequentialPrefetchMaxSize$value=" + this.sequentialPrefetchMaxSize$value + ", blockReadTimeout$value=" + this.blockReadTimeout$value + ", blockReadRetryCount$value=" + this.blockReadRetryCount$value + ", smallObjectsPrefetchingEnabled$value=" + this.smallObjectsPrefetchingEnabled$value + ", smallObjectSizeThreshold$value=" + this.smallObjectSizeThreshold$value + ", threadPoolSize$value=" + this.threadPoolSize$value + ", readBufferSize$value=" + this.readBufferSize$value + ", targetRequestSize$value=" + this.targetRequestSize$value + ", requestToleranceRatio$value=" + this.requestToleranceRatio$value + ")";
        }
    }
}

