/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.s3.analyticsaccelerator.ObjectClientConfiguration;
import software.amazon.s3.analyticsaccelerator.ObjectClientTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.ConfigurableTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.request.GetRequest;
import software.amazon.s3.analyticsaccelerator.request.HeadRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectContent;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.RequestFactory;
import software.amazon.s3.analyticsaccelerator.request.UserAgent;
import software.amazon.s3.analyticsaccelerator.util.ObjectClientUtil;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;

public class S3SyncSdkObjectClient
implements ObjectClient {
    @NonNull
    private final S3Client s3Client;
    @NonNull
    private final Telemetry telemetry;
    @NonNull
    private final UserAgent userAgent;
    RequestFactory requestFactory;

    public S3SyncSdkObjectClient(@NonNull S3Client s3Client) {
        this(s3Client, ObjectClientConfiguration.DEFAULT);
        if (s3Client == null) {
            throw new NullPointerException("s3Client is marked non-null but is null");
        }
    }

    public S3SyncSdkObjectClient(S3Client s3Client, ObjectClientConfiguration objectClientConfiguration) {
        this.s3Client = s3Client;
        this.telemetry = new ConfigurableTelemetry(objectClientConfiguration.getTelemetryConfiguration());
        this.userAgent = new UserAgent();
        this.userAgent.prepend(objectClientConfiguration.getUserAgentPrefix());
        String customUserAgent = Optional.ofNullable(s3Client.serviceClientConfiguration()).map(SdkServiceClientConfiguration::overrideConfiguration).flatMap(override -> override.advancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX)).orElse("");
        this.userAgent.prepend(customUserAgent);
        this.requestFactory = new RequestFactory(this.userAgent);
    }

    @Override
    public ObjectMetadata headObject(HeadRequest headRequest, OpenStreamInformation openStreamInformation) {
        HeadObjectRequest.Builder builder = this.requestFactory.buildHeadObjectRequest(headRequest, openStreamInformation);
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.sync.client.head")).attribute(ObjectClientTelemetry.uri(headRequest.getS3Uri()))).build(), () -> {
            try {
                HeadObjectResponse headObjectResponse = this.s3Client.headObject((HeadObjectRequest)builder.build());
                return ObjectMetadata.builder().contentLength(headObjectResponse.contentLength()).etag(headObjectResponse.eTag()).build();
            }
            catch (Throwable t) {
                throw ObjectClientUtil.handleException(headRequest.getS3Uri(), t);
            }
        });
    }

    @Override
    public ObjectContent getObject(GetRequest getRequest, OpenStreamInformation openStreamInformation) {
        GetObjectRequest.Builder builder = this.requestFactory.getObjectRequest(getRequest, openStreamInformation);
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.sync.client.get")).attribute(ObjectClientTelemetry.uri(getRequest.getS3Uri()))).attribute(ObjectClientTelemetry.rangeLength(getRequest.getRange()))).attribute(ObjectClientTelemetry.range(getRequest.getRange()))).build(), () -> {
            try {
                ResponseInputStream inputStream = this.s3Client.getObject((GetObjectRequest)builder.build());
                return ObjectContent.builder().stream((InputStream)inputStream).build();
            }
            catch (Throwable t) {
                throw ObjectClientUtil.handleException(getRequest.getS3Uri(), t);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.s3Client.close();
    }

    @NonNull
    @Generated
    public S3Client getS3Client() {
        return this.s3Client;
    }
}

