/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.stats;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.RemovalCause;
import software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.stats.CacheStats;
import software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.stats.StatsCounter;

final class GuardedStatsCounter
implements StatsCounter {
    static final Logger logger = Logger.getLogger(GuardedStatsCounter.class.getName());
    final StatsCounter delegate;

    GuardedStatsCounter(StatsCounter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void recordHits(int count) {
        try {
            this.delegate.recordHits(count);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordMisses(int count) {
        try {
            this.delegate.recordMisses(count);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordLoadSuccess(long loadTime) {
        try {
            this.delegate.recordLoadSuccess(loadTime);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordLoadFailure(long loadTime) {
        try {
            this.delegate.recordLoadFailure(loadTime);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordEviction() {
        try {
            this.delegate.recordEviction();
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordEviction(int weight) {
        try {
            this.delegate.recordEviction(weight);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordEviction(int weight, RemovalCause cause) {
        try {
            this.delegate.recordEviction(weight, cause);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public CacheStats snapshot() {
        try {
            return this.delegate.snapshot();
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
            return CacheStats.empty();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

