/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.impl;

import java.io.IOException;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.DefaultLogicalIOImpl;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.SequentialPrefetcher;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class SequentialLogicalIOImpl
extends DefaultLogicalIOImpl {
    private final SequentialPrefetcher sequentialPrefetcher;

    public SequentialLogicalIOImpl(@NonNull S3URI s3URI, @NonNull PhysicalIO physicalIO, @NonNull Telemetry telemetry, @NonNull LogicalIOConfiguration logicalIOConfiguration) {
        super(s3URI, physicalIO, telemetry);
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (physicalIO == null) {
            throw new NullPointerException("physicalIO is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        this.sequentialPrefetcher = new SequentialPrefetcher(s3URI, physicalIO, telemetry, logicalIOConfiguration);
    }

    @Override
    public int read(byte[] buf, int off, int len, long position) throws IOException {
        this.sequentialPrefetcher.prefetch(position);
        return super.read(buf, off, len, position);
    }

    @Override
    public void close() throws IOException {
        super.closeWithEviction(true);
    }
}

