/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Attribute;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public enum StreamAttributes {
    URI("uri"),
    ETAG("etag"),
    RANGE("range"),
    VARIANT("variant"),
    EFFECTIVE_RANGE("range.effective"),
    GENERATION("generation"),
    COLUMN("column"),
    IOPLAN("ioplan"),
    LOGICAL_READ_POSITION("logicalread.position"),
    LOGICAL_READ_LENGTH("logicalread.length"),
    RANGE_LENGTH("range.length"),
    STREAM_RELATIVE_TS("stream.relative_ts"),
    LOGICAL_IO_REL_TIMESTAMP("logicalio.ts"),
    PHYSICAL_IO_REL_TIMESTAMP("physicalio.ts");

    private final String name;

    public static Attribute uri(S3URI s3URI) {
        return Attribute.of(URI.getName(), s3URI.toString());
    }

    public static Attribute etag(String etag) {
        return Attribute.of(ETAG.getName(), etag);
    }

    public static Attribute variant(String variant) {
        return Attribute.of(VARIANT.getName(), variant);
    }

    public static Attribute range(long start, long end) {
        return StreamAttributes.range(new Range(start, end));
    }

    public static Attribute range(Range range) {
        return Attribute.of(RANGE.getName(), range.toString());
    }

    public static Attribute effectiveRange(long start, long end) {
        return StreamAttributes.effectiveRange(new Range(start, end));
    }

    public static Attribute effectiveRange(Range range) {
        return Attribute.of(EFFECTIVE_RANGE.getName(), range.toString());
    }

    public static Attribute generation(long generation) {
        return Attribute.of(GENERATION.getName(), generation);
    }

    public static Attribute column(String column) {
        return Attribute.of(COLUMN.getName(), column);
    }

    public static Attribute ioPlan(IOPlan ioPlan) {
        return Attribute.of(IOPLAN.getName(), ioPlan.toString());
    }

    public static Attribute streamRelativeTimestamp(long ts) {
        return Attribute.of(STREAM_RELATIVE_TS.getName(), ts);
    }

    public static Attribute logicalReadPosition(long pos) {
        return Attribute.of(LOGICAL_READ_POSITION.getName(), pos);
    }

    public static Attribute logicalReadLength(int len) {
        return Attribute.of(LOGICAL_READ_LENGTH.getName(), len);
    }

    public static Attribute logicalIORelativeTimestamp(long ts) {
        return Attribute.of(LOGICAL_IO_REL_TIMESTAMP.getName(), ts);
    }

    public static Attribute physicalIORelativeTimestamp(long ts) {
        return Attribute.of(PHYSICAL_IO_REL_TIMESTAMP.getName(), ts);
    }

    public static Attribute rangeLength(long ts) {
        return Attribute.of(RANGE_LENGTH.getName(), ts);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    private StreamAttributes(String name) {
        this.name = name;
    }
}

