/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStream;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStreamConfiguration;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIO;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.DefaultLogicalIOImpl;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetColumnPrefetchStore;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetLogicalIOImpl;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.MetadataStore;
import software.amazon.s3.analyticsaccelerator.io.physical.impl.PhysicalIOImpl;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.ObjectFormatSelector;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class S3SeekableInputStreamFactory
implements AutoCloseable {
    private final S3SeekableInputStreamConfiguration configuration;
    private final ParquetColumnPrefetchStore parquetColumnPrefetchStore;
    private final MetadataStore objectMetadataStore;
    private final BlobStore objectBlobStore;
    private final Telemetry telemetry;
    private final ObjectFormatSelector objectFormatSelector;

    public S3SeekableInputStreamFactory(@NonNull ObjectClient objectClient, @NonNull S3SeekableInputStreamConfiguration configuration) {
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.configuration = configuration;
        this.telemetry = Telemetry.createTelemetry(configuration.getTelemetryConfiguration());
        this.parquetColumnPrefetchStore = new ParquetColumnPrefetchStore(configuration.getLogicalIOConfiguration());
        this.objectMetadataStore = new MetadataStore(objectClient, this.telemetry, configuration.getPhysicalIOConfiguration());
        this.objectFormatSelector = new ObjectFormatSelector(configuration.getLogicalIOConfiguration());
        this.objectBlobStore = new BlobStore(objectClient, this.telemetry, configuration.getPhysicalIOConfiguration());
    }

    public S3SeekableInputStream createStream(@NonNull S3URI s3URI) throws IOException {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        return new S3SeekableInputStream(s3URI, this.createLogicalIO(s3URI), this.telemetry);
    }

    public S3SeekableInputStream createStream(@NonNull S3URI s3URI, ObjectMetadata metadata) throws IOException {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        this.storeObjectMetadata(s3URI, metadata);
        return new S3SeekableInputStream(s3URI, this.createLogicalIO(s3URI), this.telemetry);
    }

    public S3SeekableInputStream createStream(@NonNull S3URI s3URI, @NonNull OpenStreamInformation openStreamInformation) throws IOException {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (openStreamInformation == null) {
            throw new NullPointerException("openStreamInformation is marked non-null but is null");
        }
        this.storeObjectMetadata(s3URI, openStreamInformation.getObjectMetadata());
        return new S3SeekableInputStream(s3URI, this.createLogicalIO(s3URI, openStreamInformation), this.telemetry);
    }

    LogicalIO createLogicalIO(S3URI s3URI) throws IOException {
        return this.createLogicalIO(s3URI, OpenStreamInformation.DEFAULT);
    }

    LogicalIO createLogicalIO(S3URI s3URI, OpenStreamInformation openStreamInformation) throws IOException {
        switch (this.objectFormatSelector.getObjectFormat(s3URI, openStreamInformation)) {
            case PARQUET: {
                return new ParquetLogicalIOImpl(s3URI, new PhysicalIOImpl(s3URI, this.objectMetadataStore, this.objectBlobStore, this.telemetry, openStreamInformation.getStreamContext()), this.telemetry, this.configuration.getLogicalIOConfiguration(), this.parquetColumnPrefetchStore);
            }
        }
        return new DefaultLogicalIOImpl(s3URI, new PhysicalIOImpl(s3URI, this.objectMetadataStore, this.objectBlobStore, this.telemetry, openStreamInformation.getStreamContext()), this.telemetry);
    }

    void storeObjectMetadata(S3URI s3URI, ObjectMetadata metadata) {
        if (metadata != null) {
            this.objectMetadataStore.storeObjectMetadata(s3URI, metadata);
        }
    }

    @Override
    public void close() throws IOException {
        this.objectMetadataStore.close();
        this.objectBlobStore.close();
        this.telemetry.close();
    }

    @Generated
    S3SeekableInputStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    ParquetColumnPrefetchStore getParquetColumnPrefetchStore() {
        return this.parquetColumnPrefetchStore;
    }

    @Generated
    MetadataStore getObjectMetadataStore() {
        return this.objectMetadataStore;
    }

    @Generated
    BlobStore getObjectBlobStore() {
        return this.objectBlobStore;
    }

    @Generated
    Telemetry getTelemetry() {
        return this.telemetry;
    }

    @Generated
    ObjectFormatSelector getObjectFormatSelector() {
        return this.objectFormatSelector;
    }
}

