/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PrefetchMode {
    OFF("off"),
    ALL("all"),
    ROW_GROUP("row_group"),
    COLUMN_BOUND("column_bound");

    private final String name;
    private static final Logger LOG;

    private PrefetchMode(String name) {
        this.name = name;
    }

    public static PrefetchMode fromString(String prefetchMode) {
        for (PrefetchMode value : PrefetchMode.values()) {
            if (!value.name.equalsIgnoreCase(prefetchMode)) continue;
            return value;
        }
        LOG.warn("Unknown prefetch mode {}, using default row_group mode.", (Object)prefetchMode);
        return ROW_GROUP;
    }

    static {
        LOG = LoggerFactory.getLogger(PrefetchMode.class);
    }
}

