/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalLong;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockStore;
import software.amazon.s3.analyticsaccelerator.request.Range;

public class IOPlanner {
    private final BlockStore blockStore;

    public IOPlanner(@NonNull BlockStore blockStore) {
        if (blockStore == null) {
            throw new NullPointerException("blockStore is marked non-null but is null");
        }
        this.blockStore = blockStore;
    }

    public List<Range> planRead(long pos, long end, long lastObjectByte) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must be non-negative");
        Preconditions.checkArgument(pos <= end, "`pos` must be less than or equal to `end`");
        Preconditions.checkArgument(pos <= lastObjectByte, "`pos` must be less than or equal to `lastObjectByte`");
        LinkedList<Range> missingRanges = new LinkedList<Range>();
        OptionalLong nextMissingByte = this.blockStore.findNextMissingByte(pos);
        while (nextMissingByte.isPresent() && nextMissingByte.getAsLong() <= Math.min(end, lastObjectByte)) {
            OptionalLong nextAvailableByte = this.blockStore.findNextLoadedByte(nextMissingByte.getAsLong());
            long endOfRange = nextAvailableByte.isPresent() ? Math.min(end, nextAvailableByte.getAsLong() - 1L) : Math.min(end, lastObjectByte);
            missingRanges.add(new Range(nextMissingByte.getAsLong(), endOfRange));
            nextMissingByte = this.blockStore.findNextMissingByte(endOfRange + 1L);
        }
        return missingRanges;
    }
}

