/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.logging.Level;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.common.telemetry.LoggingTelemetryReporter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryLevel;

public final class TelemetryConfiguration {
    public static final String LEVEL_KEY = "level";
    public static final String DEFAULT_LEVEL = TelemetryLevel.STANDARD.toString();
    public static final String STD_OUT_ENABLED_KEY = "std.out.enabled";
    public static final boolean DEFAULT_STD_OUT_ENABLED = false;
    public static final String LOGGING_ENABLED_KEY = "logging.enabled";
    public static final boolean DEFAULT_LOGGING_ENABLED = true;
    public static final String AGGREGATIONS_ENABLED_KEY = "aggregations.enabled";
    public static final boolean DEFAULT_AGGREGATIONS_ENABLED = false;
    public static final String AGGREGATIONS_FLUSH_INTERVAL_SECONDS_KEY = "aggregations.flush.interval.seconds";
    public static final String LOGGING_LEVEL_KEY = "logging.level";
    public static final String DEFAULT_LOGGING_LEVEL = Level.INFO.toString();
    public static final String LOGGING_NAME_KEY = "logging.name";
    public static final String DEFAULT_LOGGING_NAME = LoggingTelemetryReporter.DEFAULT_LOGGING_NAME;
    public static final String TELEMETRY_FORMAT_KEY = "format";
    public static final String DEFAULT_TELEMETRY_FORMAT = "default";
    private final String level;
    private final boolean stdOutEnabled;
    private final boolean loggingEnabled;
    private final boolean aggregationsEnabled;
    @NonNull
    private final Optional<Duration> aggregationsFlushInterval;
    @NonNull
    private final String loggingLevel;
    @NonNull
    private final String loggingName;
    @NonNull
    private final String telemetryFormat;
    public static final TelemetryConfiguration DEFAULT = TelemetryConfiguration.builder().build();

    public static TelemetryConfiguration fromConfiguration(@NonNull ConnectorConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        int aggregationsFlushIntervalSecondsRaw = configuration.getInt(AGGREGATIONS_FLUSH_INTERVAL_SECONDS_KEY, -1);
        Optional<Duration> aggregationsFlushInterval = Optional.empty();
        if (aggregationsFlushIntervalSecondsRaw > 0) {
            aggregationsFlushInterval = Optional.of(Duration.of(aggregationsFlushIntervalSecondsRaw, ChronoUnit.SECONDS));
        }
        return TelemetryConfiguration.builder().level(configuration.getString(LEVEL_KEY, DEFAULT_LEVEL)).stdOutEnabled(configuration.getBoolean(STD_OUT_ENABLED_KEY, false)).loggingEnabled(configuration.getBoolean(LOGGING_ENABLED_KEY, true)).aggregationsEnabled(configuration.getBoolean(AGGREGATIONS_ENABLED_KEY, false)).aggregationsFlushInterval(aggregationsFlushInterval).loggingName(configuration.getString(LOGGING_NAME_KEY, DEFAULT_LOGGING_NAME)).loggingLevel(configuration.getString(LOGGING_LEVEL_KEY, DEFAULT_LOGGING_LEVEL)).telemetryFormat(configuration.getString(TELEMETRY_FORMAT_KEY, DEFAULT_TELEMETRY_FORMAT)).build();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Telemetry configuration:\n");
        builder.append("\tlevel: ").append(this.level).append("\n");
        builder.append("\tstdOutEnabled: ").append(this.stdOutEnabled).append("\n");
        builder.append("\tloggingEnabled: ").append(this.loggingEnabled).append("\n");
        builder.append("\taggregationsEnabled: ").append(this.aggregationsEnabled).append("\n");
        builder.append("\tloggingLevel: ").append(this.loggingLevel).append("\n");
        builder.append("\ttelemetryFormat: ").append(this.telemetryFormat).append("\n");
        return builder.toString();
    }

    @Generated
    private static String $default$level() {
        return DEFAULT_LEVEL;
    }

    @Generated
    private static boolean $default$stdOutEnabled() {
        return false;
    }

    @Generated
    private static boolean $default$loggingEnabled() {
        return true;
    }

    @Generated
    private static boolean $default$aggregationsEnabled() {
        return false;
    }

    @Generated
    private static Optional<Duration> $default$aggregationsFlushInterval() {
        return Optional.empty();
    }

    @Generated
    private static String $default$loggingLevel() {
        return DEFAULT_LOGGING_LEVEL;
    }

    @Generated
    private static String $default$loggingName() {
        return DEFAULT_LOGGING_NAME;
    }

    @Generated
    private static String $default$telemetryFormat() {
        return DEFAULT_TELEMETRY_FORMAT;
    }

    @Generated
    TelemetryConfiguration(String level, boolean stdOutEnabled, boolean loggingEnabled, boolean aggregationsEnabled, @NonNull Optional<Duration> aggregationsFlushInterval, @NonNull String loggingLevel, @NonNull String loggingName, @NonNull String telemetryFormat) {
        if (aggregationsFlushInterval == null) {
            throw new NullPointerException("aggregationsFlushInterval is marked non-null but is null");
        }
        if (loggingLevel == null) {
            throw new NullPointerException("loggingLevel is marked non-null but is null");
        }
        if (loggingName == null) {
            throw new NullPointerException("loggingName is marked non-null but is null");
        }
        if (telemetryFormat == null) {
            throw new NullPointerException("telemetryFormat is marked non-null but is null");
        }
        this.level = level;
        this.stdOutEnabled = stdOutEnabled;
        this.loggingEnabled = loggingEnabled;
        this.aggregationsEnabled = aggregationsEnabled;
        this.aggregationsFlushInterval = aggregationsFlushInterval;
        this.loggingLevel = loggingLevel;
        this.loggingName = loggingName;
        this.telemetryFormat = telemetryFormat;
    }

    @Generated
    public static TelemetryConfigurationBuilder builder() {
        return new TelemetryConfigurationBuilder();
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public boolean isStdOutEnabled() {
        return this.stdOutEnabled;
    }

    @Generated
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Generated
    public boolean isAggregationsEnabled() {
        return this.aggregationsEnabled;
    }

    @NonNull
    @Generated
    public Optional<Duration> getAggregationsFlushInterval() {
        return this.aggregationsFlushInterval;
    }

    @NonNull
    @Generated
    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    @NonNull
    @Generated
    public String getLoggingName() {
        return this.loggingName;
    }

    @NonNull
    @Generated
    public String getTelemetryFormat() {
        return this.telemetryFormat;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelemetryConfiguration)) {
            return false;
        }
        TelemetryConfiguration other = (TelemetryConfiguration)o;
        if (this.isStdOutEnabled() != other.isStdOutEnabled()) {
            return false;
        }
        if (this.isLoggingEnabled() != other.isLoggingEnabled()) {
            return false;
        }
        if (this.isAggregationsEnabled() != other.isAggregationsEnabled()) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        Optional<Duration> this$aggregationsFlushInterval = this.getAggregationsFlushInterval();
        Optional<Duration> other$aggregationsFlushInterval = other.getAggregationsFlushInterval();
        if (this$aggregationsFlushInterval == null ? other$aggregationsFlushInterval != null : !((Object)this$aggregationsFlushInterval).equals(other$aggregationsFlushInterval)) {
            return false;
        }
        String this$loggingLevel = this.getLoggingLevel();
        String other$loggingLevel = other.getLoggingLevel();
        if (this$loggingLevel == null ? other$loggingLevel != null : !this$loggingLevel.equals(other$loggingLevel)) {
            return false;
        }
        String this$loggingName = this.getLoggingName();
        String other$loggingName = other.getLoggingName();
        if (this$loggingName == null ? other$loggingName != null : !this$loggingName.equals(other$loggingName)) {
            return false;
        }
        String this$telemetryFormat = this.getTelemetryFormat();
        String other$telemetryFormat = other.getTelemetryFormat();
        return !(this$telemetryFormat == null ? other$telemetryFormat != null : !this$telemetryFormat.equals(other$telemetryFormat));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStdOutEnabled() ? 79 : 97);
        result = result * 59 + (this.isLoggingEnabled() ? 79 : 97);
        result = result * 59 + (this.isAggregationsEnabled() ? 79 : 97);
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        Optional<Duration> $aggregationsFlushInterval = this.getAggregationsFlushInterval();
        result = result * 59 + ($aggregationsFlushInterval == null ? 43 : ((Object)$aggregationsFlushInterval).hashCode());
        String $loggingLevel = this.getLoggingLevel();
        result = result * 59 + ($loggingLevel == null ? 43 : $loggingLevel.hashCode());
        String $loggingName = this.getLoggingName();
        result = result * 59 + ($loggingName == null ? 43 : $loggingName.hashCode());
        String $telemetryFormat = this.getTelemetryFormat();
        result = result * 59 + ($telemetryFormat == null ? 43 : $telemetryFormat.hashCode());
        return result;
    }

    @Generated
    public static class TelemetryConfigurationBuilder {
        @Generated
        private boolean level$set;
        @Generated
        private String level$value;
        @Generated
        private boolean stdOutEnabled$set;
        @Generated
        private boolean stdOutEnabled$value;
        @Generated
        private boolean loggingEnabled$set;
        @Generated
        private boolean loggingEnabled$value;
        @Generated
        private boolean aggregationsEnabled$set;
        @Generated
        private boolean aggregationsEnabled$value;
        @Generated
        private boolean aggregationsFlushInterval$set;
        @Generated
        private Optional<Duration> aggregationsFlushInterval$value;
        @Generated
        private boolean loggingLevel$set;
        @Generated
        private String loggingLevel$value;
        @Generated
        private boolean loggingName$set;
        @Generated
        private String loggingName$value;
        @Generated
        private boolean telemetryFormat$set;
        @Generated
        private String telemetryFormat$value;

        @Generated
        TelemetryConfigurationBuilder() {
        }

        @Generated
        public TelemetryConfigurationBuilder level(String level) {
            this.level$value = level;
            this.level$set = true;
            return this;
        }

        @Generated
        public TelemetryConfigurationBuilder stdOutEnabled(boolean stdOutEnabled) {
            this.stdOutEnabled$value = stdOutEnabled;
            this.stdOutEnabled$set = true;
            return this;
        }

        @Generated
        public TelemetryConfigurationBuilder loggingEnabled(boolean loggingEnabled) {
            this.loggingEnabled$value = loggingEnabled;
            this.loggingEnabled$set = true;
            return this;
        }

        @Generated
        public TelemetryConfigurationBuilder aggregationsEnabled(boolean aggregationsEnabled) {
            this.aggregationsEnabled$value = aggregationsEnabled;
            this.aggregationsEnabled$set = true;
            return this;
        }

        @Generated
        public TelemetryConfigurationBuilder aggregationsFlushInterval(@NonNull Optional<Duration> aggregationsFlushInterval) {
            if (aggregationsFlushInterval == null) {
                throw new NullPointerException("aggregationsFlushInterval is marked non-null but is null");
            }
            this.aggregationsFlushInterval$value = aggregationsFlushInterval;
            this.aggregationsFlushInterval$set = true;
            return this;
        }

        @Generated
        public TelemetryConfigurationBuilder loggingLevel(@NonNull String loggingLevel) {
            if (loggingLevel == null) {
                throw new NullPointerException("loggingLevel is marked non-null but is null");
            }
            this.loggingLevel$value = loggingLevel;
            this.loggingLevel$set = true;
            return this;
        }

        @Generated
        public TelemetryConfigurationBuilder loggingName(@NonNull String loggingName) {
            if (loggingName == null) {
                throw new NullPointerException("loggingName is marked non-null but is null");
            }
            this.loggingName$value = loggingName;
            this.loggingName$set = true;
            return this;
        }

        @Generated
        public TelemetryConfigurationBuilder telemetryFormat(@NonNull String telemetryFormat) {
            if (telemetryFormat == null) {
                throw new NullPointerException("telemetryFormat is marked non-null but is null");
            }
            this.telemetryFormat$value = telemetryFormat;
            this.telemetryFormat$set = true;
            return this;
        }

        @Generated
        public TelemetryConfiguration build() {
            String level$value = this.level$value;
            if (!this.level$set) {
                level$value = TelemetryConfiguration.$default$level();
            }
            boolean stdOutEnabled$value = this.stdOutEnabled$value;
            if (!this.stdOutEnabled$set) {
                stdOutEnabled$value = TelemetryConfiguration.$default$stdOutEnabled();
            }
            boolean loggingEnabled$value = this.loggingEnabled$value;
            if (!this.loggingEnabled$set) {
                loggingEnabled$value = TelemetryConfiguration.$default$loggingEnabled();
            }
            boolean aggregationsEnabled$value = this.aggregationsEnabled$value;
            if (!this.aggregationsEnabled$set) {
                aggregationsEnabled$value = TelemetryConfiguration.$default$aggregationsEnabled();
            }
            Optional aggregationsFlushInterval$value = this.aggregationsFlushInterval$value;
            if (!this.aggregationsFlushInterval$set) {
                aggregationsFlushInterval$value = TelemetryConfiguration.$default$aggregationsFlushInterval();
            }
            String loggingLevel$value = this.loggingLevel$value;
            if (!this.loggingLevel$set) {
                loggingLevel$value = TelemetryConfiguration.$default$loggingLevel();
            }
            String loggingName$value = this.loggingName$value;
            if (!this.loggingName$set) {
                loggingName$value = TelemetryConfiguration.$default$loggingName();
            }
            String telemetryFormat$value = this.telemetryFormat$value;
            if (!this.telemetryFormat$set) {
                telemetryFormat$value = TelemetryConfiguration.$default$telemetryFormat();
            }
            return new TelemetryConfiguration(level$value, stdOutEnabled$value, loggingEnabled$value, aggregationsEnabled$value, aggregationsFlushInterval$value, loggingLevel$value, loggingName$value, telemetryFormat$value);
        }

        @Generated
        public String toString() {
            return "TelemetryConfiguration.TelemetryConfigurationBuilder(level$value=" + this.level$value + ", stdOutEnabled$value=" + this.stdOutEnabled$value + ", loggingEnabled$value=" + this.loggingEnabled$value + ", aggregationsEnabled$value=" + this.aggregationsEnabled$value + ", aggregationsFlushInterval$value=" + this.aggregationsFlushInterval$value + ", loggingLevel$value=" + this.loggingLevel$value + ", loggingName$value=" + this.loggingName$value + ", telemetryFormat$value=" + this.telemetryFormat$value + ")";
        }
    }
}

