/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.request.Range;

public final class RangeOptimiser {
    private final PhysicalIOConfiguration configuration;

    public List<Range> splitRanges(List<Range> ranges) {
        LinkedList<Range> splits = new LinkedList<Range>();
        for (Range range : ranges) {
            if (range.getLength() > this.configuration.getMaxRangeSizeBytes()) {
                this.splitRange(range.getStart(), range.getEnd()).forEach(splits::add);
                continue;
            }
            splits.add(range);
        }
        return splits;
    }

    private List<Range> splitRange(long start, long end) {
        long nextRangeStart = start;
        LinkedList<Range> generatedRanges = new LinkedList<Range>();
        while (nextRangeStart < end) {
            long rangeEnd = Math.min(nextRangeStart + this.configuration.getPartSizeBytes() - 1L, end);
            generatedRanges.add(new Range(nextRangeStart, rangeEnd));
            nextRangeStart = rangeEnd + 1L;
        }
        return generatedRanges;
    }

    @Generated
    public RangeOptimiser(PhysicalIOConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public PhysicalIOConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeOptimiser)) {
            return false;
        }
        RangeOptimiser other = (RangeOptimiser)o;
        PhysicalIOConfiguration this$configuration = this.getConfiguration();
        PhysicalIOConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalIOConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RangeOptimiser(configuration=" + this.getConfiguration() + ")";
    }
}

