/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.request.GetRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectContent;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.request.Referrer;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;
import software.amazon.s3.analyticsaccelerator.util.StreamUtils;

public class Block
implements Closeable {
    private CompletableFuture<ObjectContent> source;
    private CompletableFuture<byte[]> data;
    private final S3URI s3URI;
    private final Range range;
    private final Telemetry telemetry;
    private final long start;
    private final long end;
    private final long generation;
    private static final String OPERATION_BLOCK_GET_ASYNC = "block.get.async";
    private static final String OPERATION_BLOCK_GET_JOIN = "block.get.join";

    public Block(@NonNull S3URI s3URI, @NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, long start, long end, long generation, @NonNull ReadMode readMode) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (readMode == null) {
            throw new NullPointerException("readMode is marked non-null but is null");
        }
        Preconditions.checkArgument(0L <= generation, "`generation` must be non-negative; was: %s", generation);
        Preconditions.checkArgument(0L <= start, "`start` must be non-negative; was: %s", start);
        Preconditions.checkArgument(0L <= end, "`end` must be non-negative; was: %s", end);
        Preconditions.checkArgument(start <= end, "`start` must be less than `end`; %s is not less than %s", start, end);
        this.start = start;
        this.end = end;
        this.generation = generation;
        this.telemetry = telemetry;
        this.s3URI = s3URI;
        this.range = new Range(start, end);
        this.source = this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_BLOCK_GET_ASYNC)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(this.range))).attribute(StreamAttributes.generation(generation))).build(), objectClient.getObject(GetRequest.builder().s3Uri(this.s3URI).range(this.range).referrer(new Referrer(this.range.toHttpString(), readMode)).build()));
        this.data = this.source.thenApply(StreamUtils::toByteArray);
    }

    public int read(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        byte[] content = this.getData();
        return Byte.toUnsignedInt(content[this.posToOffset(pos)]);
    }

    public int read(byte @NonNull [] buf, int off, int len, long pos) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        byte[] content = this.getData();
        int available = content.length - this.posToOffset(pos);
        int bytesToCopy = Math.min(len, available);
        for (int i = 0; i < bytesToCopy; ++i) {
            buf[off + i] = content[this.posToOffset(pos) + i];
        }
        return bytesToCopy;
    }

    public boolean contains(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        return this.start <= pos && pos <= this.end;
    }

    private int posToOffset(long pos) {
        return (int)(pos - this.start);
    }

    private byte[] getData() {
        return this.telemetry.measureJoinCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_BLOCK_GET_JOIN)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(this.range))).attribute(StreamAttributes.rangeLength(this.range.getLength()))).build(), this.data);
    }

    @Override
    public void close() {
        this.source.cancel(false);
    }

    @Generated
    public long getStart() {
        return this.start;
    }

    @Generated
    public long getEnd() {
        return this.end;
    }

    @Generated
    public long getGeneration() {
        return this.generation;
    }
}

