/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;

public class S3SeekableInputStreamConfiguration {
    public static final String PHYSICAL_IO_PREFIX = "physicalio";
    public static final String LOGICAL_IO_PREFIX = "logicalio";
    public static final String TELEMETRY_PREFIX = "telemetry";
    @NonNull
    private PhysicalIOConfiguration physicalIOConfiguration;
    @NonNull
    private LogicalIOConfiguration logicalIOConfiguration;
    @NonNull
    private TelemetryConfiguration telemetryConfiguration;
    public static final S3SeekableInputStreamConfiguration DEFAULT = S3SeekableInputStreamConfiguration.builder().build();

    public static S3SeekableInputStreamConfiguration fromConfiguration(ConnectorConfiguration configuration) {
        return S3SeekableInputStreamConfiguration.builder().physicalIOConfiguration(PhysicalIOConfiguration.fromConfiguration(configuration.map(PHYSICAL_IO_PREFIX))).logicalIOConfiguration(LogicalIOConfiguration.fromConfiguration(configuration.map(LOGICAL_IO_PREFIX))).telemetryConfiguration(TelemetryConfiguration.fromConfiguration(configuration.map(TELEMETRY_PREFIX))).build();
    }

    @Generated
    private static PhysicalIOConfiguration $default$physicalIOConfiguration() {
        return PhysicalIOConfiguration.DEFAULT;
    }

    @Generated
    private static LogicalIOConfiguration $default$logicalIOConfiguration() {
        return LogicalIOConfiguration.DEFAULT;
    }

    @Generated
    private static TelemetryConfiguration $default$telemetryConfiguration() {
        return TelemetryConfiguration.DEFAULT;
    }

    @Generated
    S3SeekableInputStreamConfiguration(@NonNull PhysicalIOConfiguration physicalIOConfiguration, @NonNull LogicalIOConfiguration logicalIOConfiguration, @NonNull TelemetryConfiguration telemetryConfiguration) {
        if (physicalIOConfiguration == null) {
            throw new NullPointerException("physicalIOConfiguration is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        if (telemetryConfiguration == null) {
            throw new NullPointerException("telemetryConfiguration is marked non-null but is null");
        }
        this.physicalIOConfiguration = physicalIOConfiguration;
        this.logicalIOConfiguration = logicalIOConfiguration;
        this.telemetryConfiguration = telemetryConfiguration;
    }

    @Generated
    public static S3SeekableInputStreamConfigurationBuilder builder() {
        return new S3SeekableInputStreamConfigurationBuilder();
    }

    @NonNull
    @Generated
    public PhysicalIOConfiguration getPhysicalIOConfiguration() {
        return this.physicalIOConfiguration;
    }

    @NonNull
    @Generated
    public LogicalIOConfiguration getLogicalIOConfiguration() {
        return this.logicalIOConfiguration;
    }

    @NonNull
    @Generated
    public TelemetryConfiguration getTelemetryConfiguration() {
        return this.telemetryConfiguration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3SeekableInputStreamConfiguration)) {
            return false;
        }
        S3SeekableInputStreamConfiguration other = (S3SeekableInputStreamConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalIOConfiguration this$physicalIOConfiguration = this.getPhysicalIOConfiguration();
        PhysicalIOConfiguration other$physicalIOConfiguration = other.getPhysicalIOConfiguration();
        if (this$physicalIOConfiguration == null ? other$physicalIOConfiguration != null : !((Object)this$physicalIOConfiguration).equals(other$physicalIOConfiguration)) {
            return false;
        }
        LogicalIOConfiguration this$logicalIOConfiguration = this.getLogicalIOConfiguration();
        LogicalIOConfiguration other$logicalIOConfiguration = other.getLogicalIOConfiguration();
        if (this$logicalIOConfiguration == null ? other$logicalIOConfiguration != null : !((Object)this$logicalIOConfiguration).equals(other$logicalIOConfiguration)) {
            return false;
        }
        TelemetryConfiguration this$telemetryConfiguration = this.getTelemetryConfiguration();
        TelemetryConfiguration other$telemetryConfiguration = other.getTelemetryConfiguration();
        return !(this$telemetryConfiguration == null ? other$telemetryConfiguration != null : !((Object)this$telemetryConfiguration).equals(other$telemetryConfiguration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof S3SeekableInputStreamConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalIOConfiguration $physicalIOConfiguration = this.getPhysicalIOConfiguration();
        result = result * 59 + ($physicalIOConfiguration == null ? 43 : ((Object)$physicalIOConfiguration).hashCode());
        LogicalIOConfiguration $logicalIOConfiguration = this.getLogicalIOConfiguration();
        result = result * 59 + ($logicalIOConfiguration == null ? 43 : ((Object)$logicalIOConfiguration).hashCode());
        TelemetryConfiguration $telemetryConfiguration = this.getTelemetryConfiguration();
        result = result * 59 + ($telemetryConfiguration == null ? 43 : ((Object)$telemetryConfiguration).hashCode());
        return result;
    }

    @Generated
    public static class S3SeekableInputStreamConfigurationBuilder {
        @Generated
        private boolean physicalIOConfiguration$set;
        @Generated
        private PhysicalIOConfiguration physicalIOConfiguration$value;
        @Generated
        private boolean logicalIOConfiguration$set;
        @Generated
        private LogicalIOConfiguration logicalIOConfiguration$value;
        @Generated
        private boolean telemetryConfiguration$set;
        @Generated
        private TelemetryConfiguration telemetryConfiguration$value;

        @Generated
        S3SeekableInputStreamConfigurationBuilder() {
        }

        @Generated
        public S3SeekableInputStreamConfigurationBuilder physicalIOConfiguration(@NonNull PhysicalIOConfiguration physicalIOConfiguration) {
            if (physicalIOConfiguration == null) {
                throw new NullPointerException("physicalIOConfiguration is marked non-null but is null");
            }
            this.physicalIOConfiguration$value = physicalIOConfiguration;
            this.physicalIOConfiguration$set = true;
            return this;
        }

        @Generated
        public S3SeekableInputStreamConfigurationBuilder logicalIOConfiguration(@NonNull LogicalIOConfiguration logicalIOConfiguration) {
            if (logicalIOConfiguration == null) {
                throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
            }
            this.logicalIOConfiguration$value = logicalIOConfiguration;
            this.logicalIOConfiguration$set = true;
            return this;
        }

        @Generated
        public S3SeekableInputStreamConfigurationBuilder telemetryConfiguration(@NonNull TelemetryConfiguration telemetryConfiguration) {
            if (telemetryConfiguration == null) {
                throw new NullPointerException("telemetryConfiguration is marked non-null but is null");
            }
            this.telemetryConfiguration$value = telemetryConfiguration;
            this.telemetryConfiguration$set = true;
            return this;
        }

        @Generated
        public S3SeekableInputStreamConfiguration build() {
            PhysicalIOConfiguration physicalIOConfiguration$value = this.physicalIOConfiguration$value;
            if (!this.physicalIOConfiguration$set) {
                physicalIOConfiguration$value = S3SeekableInputStreamConfiguration.$default$physicalIOConfiguration();
            }
            LogicalIOConfiguration logicalIOConfiguration$value = this.logicalIOConfiguration$value;
            if (!this.logicalIOConfiguration$set) {
                logicalIOConfiguration$value = S3SeekableInputStreamConfiguration.$default$logicalIOConfiguration();
            }
            TelemetryConfiguration telemetryConfiguration$value = this.telemetryConfiguration$value;
            if (!this.telemetryConfiguration$set) {
                telemetryConfiguration$value = S3SeekableInputStreamConfiguration.$default$telemetryConfiguration();
            }
            return new S3SeekableInputStreamConfiguration(physicalIOConfiguration$value, logicalIOConfiguration$value, telemetryConfiguration$value);
        }

        @Generated
        public String toString() {
            return "S3SeekableInputStreamConfiguration.S3SeekableInputStreamConfigurationBuilder(physicalIOConfiguration$value=" + this.physicalIOConfiguration$value + ", logicalIOConfiguration$value=" + this.logicalIOConfiguration$value + ", telemetryConfiguration$value=" + this.telemetryConfiguration$value + ")";
        }
    }
}

