/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsAccountIdResolver;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsUtil;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.endpoints.internal.Arn;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceForPrefixRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceForPrefixResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.utils.Logger;

public class S3AccessGrantsCachedAccountIdResolver
implements S3AccessGrantsAccountIdResolver {
    private int maxCacheSize = 1000;
    private int expireCacheAfterWriteSeconds = 600;
    private static final Logger logger = Logger.loggerFor(S3AccessGrantsCachedAccountIdResolver.class);
    private Cache<String, String> cache;

    public int maxCacheSize() {
        return this.maxCacheSize;
    }

    public int expireCacheAfterWriteSeconds() {
        return this.expireCacheAfterWriteSeconds;
    }

    protected CacheStats getCacheStats() {
        return this.cache.stats();
    }

    S3AccessGrantsCachedAccountIdResolver() {
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public String resolve(String accountId, String s3Prefix, S3ControlAsyncClient s3ControlAsyncClient) {
        String bucketName = S3AccessGrantsUtil.getBucketName(s3Prefix);
        String s3PrefixAccountId = (String)this.cache.getIfPresent((Object)bucketName);
        if (s3PrefixAccountId == null) {
            logger.debug(() -> "Account Id not available in the cache. Fetching account from server.");
            if (s3ControlAsyncClient == null) {
                throw new IllegalArgumentException("S3ControlAsyncClient is required for the access grants instance account resolver!");
            }
            s3PrefixAccountId = this.resolveFromService(accountId, s3Prefix, s3ControlAsyncClient);
            this.cache.put((Object)bucketName, (Object)s3PrefixAccountId);
        }
        return s3PrefixAccountId;
    }

    private String resolveFromService(String accountId, String s3Prefix, S3ControlAsyncClient s3ControlAsyncClient) {
        CompletableFuture accessGrantsInstanceForPrefix = s3ControlAsyncClient.getAccessGrantsInstanceForPrefix((GetAccessGrantsInstanceForPrefixRequest)GetAccessGrantsInstanceForPrefixRequest.builder().accountId(accountId).s3Prefix(s3Prefix).build());
        String accessGrantsInstanceArn = ((GetAccessGrantsInstanceForPrefixResponse)accessGrantsInstanceForPrefix.join()).accessGrantsInstanceArn();
        Optional optionalArn = Arn.parse((String)accessGrantsInstanceArn);
        if (!optionalArn.isPresent()) {
            logger.error(() -> "accessGrantsInstanceArn is empty");
            throw S3ControlException.builder().message("accessGrantsInstanceArn is empty").build();
        }
        return ((Arn)optionalArn.get()).accountId();
    }

    static final class BuilderImpl
    implements Builder {
        private S3ControlAsyncClient S3ControlAsyncClient;
        private int maxCacheSize = 1000;
        private int expireCacheAfterWriteSeconds = 600;

        private BuilderImpl() {
        }

        public BuilderImpl(S3AccessGrantsCachedAccountIdResolver s3AccessGrantsCachedAccountIdResolver) {
            this.maxCacheSize(s3AccessGrantsCachedAccountIdResolver.maxCacheSize);
            this.expireCacheAfterWriteSeconds(s3AccessGrantsCachedAccountIdResolver.expireCacheAfterWriteSeconds);
        }

        public int maxCacheSize() {
            return this.maxCacheSize;
        }

        @Override
        public Builder maxCacheSize(int maxCacheSize) {
            if (maxCacheSize <= 0 || maxCacheSize > 1000000) {
                throw new IllegalArgumentException(String.format("maxCacheSize needs to be in range (0, %d]", 1000000));
            }
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public int expireCAcheAfterWriteSeconds() {
            return this.expireCacheAfterWriteSeconds;
        }

        @Override
        public Builder expireCacheAfterWriteSeconds(int expireCacheAfterWriteSeconds) {
            if (expireCacheAfterWriteSeconds <= 0 || expireCacheAfterWriteSeconds > 2592000) {
                throw new IllegalArgumentException(String.format("expireCacheAfterWriteSeconds needs to be in range (0, %d]", 2592000));
            }
            this.expireCacheAfterWriteSeconds = expireCacheAfterWriteSeconds;
            return this;
        }

        @Override
        public S3AccessGrantsCachedAccountIdResolver build() {
            S3AccessGrantsCachedAccountIdResolver resolver = new S3AccessGrantsCachedAccountIdResolver();
            resolver.maxCacheSize = this.maxCacheSize();
            resolver.expireCacheAfterWriteSeconds = this.expireCAcheAfterWriteSeconds();
            resolver.cache = Caffeine.newBuilder().maximumSize((long)this.maxCacheSize).expireAfterWrite(Duration.ofSeconds(this.expireCacheAfterWriteSeconds)).build();
            return resolver;
        }
    }

    public static interface Builder {
        public S3AccessGrantsCachedAccountIdResolver build();

        public Builder maxCacheSize(int var1);

        public Builder expireCacheAfterWriteSeconds(int var1);
    }
}

