/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ExecutionResult;
import com.amazon.rdsdata.client.Executor;
import com.amazon.rdsdata.client.PlaceholderUtils;
import com.amazon.rdsdata.client.TypeConverter;
import com.amazonaws.services.rdsdata.AWSRDSData;
import com.amazonaws.services.rdsdata.model.BatchExecuteStatementRequest;
import com.amazonaws.services.rdsdata.model.BeginTransactionRequest;
import com.amazonaws.services.rdsdata.model.BeginTransactionResult;
import com.amazonaws.services.rdsdata.model.CommitTransactionRequest;
import com.amazonaws.services.rdsdata.model.DecimalReturnType;
import com.amazonaws.services.rdsdata.model.ExecuteStatementRequest;
import com.amazonaws.services.rdsdata.model.ExecuteStatementResult;
import com.amazonaws.services.rdsdata.model.ResultSetOptions;
import com.amazonaws.services.rdsdata.model.RollbackTransactionRequest;
import com.amazonaws.services.rdsdata.model.SqlParameter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RdsDataClient {
    static String ERROR_EMPTY_OR_NULL_SQL = "SQL parameter is null or empty";
    private AWSRDSData rdsDataService;
    private String database;
    private String secretArn;
    private String resourceArn;

    public String beginTransaction() {
        BeginTransactionRequest request = new BeginTransactionRequest().withDatabase(this.database).withResourceArn(this.resourceArn).withSecretArn(this.secretArn);
        BeginTransactionResult response = this.rdsDataService.beginTransaction(request);
        return response.getTransactionId();
    }

    public void commitTransaction(String transactionId) {
        CommitTransactionRequest request = new CommitTransactionRequest().withTransactionId(transactionId).withResourceArn(this.resourceArn).withSecretArn(this.secretArn);
        this.rdsDataService.commitTransaction(request);
    }

    public void rollbackTransaction(String transactionId) {
        RollbackTransactionRequest request = new RollbackTransactionRequest().withTransactionId(transactionId).withResourceArn(this.resourceArn).withSecretArn(this.secretArn);
        this.rdsDataService.rollbackTransaction(request);
    }

    public Executor forSql(String sql) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)ERROR_EMPTY_OR_NULL_SQL);
        return new Executor(sql, this);
    }

    public Executor forSql(String sql, Object ... params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)ERROR_EMPTY_OR_NULL_SQL);
        if (params == null) {
            params = new Object[]{null};
        }
        PlaceholderUtils.PlaceholderConvertResult result = PlaceholderUtils.convertToNamed(sql, params);
        return new Executor(result.sql, this).withParamSets(Collections.singletonList(result.parameters));
    }

    ExecutionResult executeStatement(String transactionId, String sql, Map<String, Object> params) {
        ExecuteStatementRequest request = new ExecuteStatementRequest().withDatabase(this.database).withResourceArn(this.resourceArn).withSecretArn(this.secretArn).withSql(sql).withParameters(this.toSqlParameterList(params)).withTransactionId(transactionId).withResultSetOptions(new ResultSetOptions().withDecimalReturnType(DecimalReturnType.STRING)).withIncludeResultMetadata(Boolean.valueOf(true));
        ExecuteStatementResult response = this.rdsDataService.executeStatement(request);
        return new ExecutionResult(response.getColumnMetadata(), response.getRecords(), response.getNumberOfRecordsUpdated());
    }

    ExecutionResult batchExecuteStatement(String transactionId, String sql, List<Map<String, Object>> params) {
        BatchExecuteStatementRequest request = new BatchExecuteStatementRequest().withDatabase(this.database).withResourceArn(this.resourceArn).withSecretArn(this.secretArn).withSql(sql).withTransactionId(transactionId).withParameterSets(this.toSqlParameterSets(params));
        this.rdsDataService.batchExecuteStatement(request);
        return new ExecutionResult(Collections.emptyList(), Collections.emptyList(), 0L);
    }

    private List<SqlParameter> toSqlParameterList(Map<String, Object> params) {
        return params.entrySet().stream().map(this::toSqlParameter).collect(Collectors.toList());
    }

    private SqlParameter toSqlParameter(Map.Entry<String, Object> mapEntry) {
        String parameterName = mapEntry.getKey();
        Object value = mapEntry.getValue();
        SqlParameter parameter = new SqlParameter().withName(parameterName).withValue(TypeConverter.toField(value));
        TypeConverter.getTypeHint(value).ifPresent(hint -> parameter.setTypeHint(hint.name()));
        return parameter;
    }

    private List<List<SqlParameter>> toSqlParameterSets(List<Map<String, Object>> params) {
        return params.stream().map(this::toSqlParameterList).collect(Collectors.toList());
    }

    RdsDataClient(AWSRDSData rdsDataService, String database, String secretArn, String resourceArn) {
        this.rdsDataService = rdsDataService;
        this.database = database;
        this.secretArn = secretArn;
        this.resourceArn = resourceArn;
    }

    public static RdsDataClientBuilder builder() {
        return new RdsDataClientBuilder();
    }

    public static class RdsDataClientBuilder {
        private AWSRDSData rdsDataService;
        private String database;
        private String secretArn;
        private String resourceArn;

        RdsDataClientBuilder() {
        }

        public RdsDataClientBuilder rdsDataService(AWSRDSData rdsDataService) {
            this.rdsDataService = rdsDataService;
            return this;
        }

        public RdsDataClientBuilder database(String database) {
            this.database = database;
            return this;
        }

        public RdsDataClientBuilder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public RdsDataClientBuilder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public RdsDataClient build() {
            return new RdsDataClient(this.rdsDataService, this.database, this.secretArn, this.resourceArn);
        }

        public String toString() {
            return "RdsDataClient.RdsDataClientBuilder(rdsDataService=" + this.rdsDataService + ", database=" + this.database + ", secretArn=" + this.secretArn + ", resourceArn=" + this.resourceArn + ")";
        }
    }
}

