/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;

class FieldWriter
extends Writer {
    private Object instance;
    private Class<?> fieldType;
    private Field field;

    static Optional<FieldWriter> fieldWriterFor(Object instance, String fieldName) {
        Class<?> instanceType = instance.getClass();
        try {
            Field field = instanceType.getDeclaredField(fieldName);
            if (Modifier.isStatic(field.getModifiers())) {
                throw MappingException.staticField(instanceType, fieldName);
            }
            FieldWriter writer = new FieldWriter(instance, field.getType(), field);
            return Optional.of(writer);
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    @Override
    public void setValue(Object value) {
        try {
            this.field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw MappingException.cannotAccessField(this.instance.getClass(), this.field.getName());
        }
    }

    @Override
    public Class<?> getType() {
        return this.fieldType;
    }

    private FieldWriter(Object instance, Class<?> fieldType, Field field) {
        this.instance = instance;
        this.fieldType = fieldType;
        this.field = field;
    }
}

