/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import software.amazon.qldb.IOUsage;
import software.amazon.qldb.Result;
import software.amazon.qldb.TimingInformation;

class BufferedResult
implements Result {
    private final List<IonValue> bufferedValues;
    private final IOUsage ioUsage;
    private final TimingInformation timingInfo;

    BufferedResult(Result result) {
        ArrayList tempValues = new ArrayList();
        result.iterator().forEachRemaining(tempValues::add);
        this.bufferedValues = Collections.unmodifiableList(tempValues);
        this.ioUsage = result.getConsumedIOs();
        this.timingInfo = result.getTimingInformation();
    }

    @Override
    public boolean isEmpty() {
        return this.bufferedValues.isEmpty();
    }

    @Override
    public IOUsage getConsumedIOs() {
        return this.ioUsage;
    }

    @Override
    public TimingInformation getTimingInformation() {
        return this.timingInfo;
    }

    @Override
    public Iterator<IonValue> iterator() {
        return this.bufferedValues.iterator();
    }
}

