/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb.exceptions;

import software.amazon.awssdk.services.qldbsession.model.QldbSessionException;

public class QldbDriverException
extends QldbSessionException {
    private static String TXN_TOKEN_PREFIX = System.lineSeparator() + "TransactionId: ";

    protected QldbDriverException(Throwable cause) {
        super(QldbSessionException.builder().cause(cause));
    }

    protected QldbDriverException(String message) {
        super(QldbSessionException.builder().message(message));
    }

    protected QldbDriverException(String message, Throwable cause) {
        super(QldbSessionException.builder().message(message).cause(cause));
    }

    public static QldbDriverException create(Throwable cause) {
        return new QldbDriverException(cause);
    }

    public static QldbDriverException create(String message) {
        return new QldbDriverException(message);
    }

    public static QldbDriverException create(String message, String transactionId) {
        String errorMessage = message + TXN_TOKEN_PREFIX + transactionId;
        return QldbDriverException.create(errorMessage);
    }

    public static QldbDriverException create(String message, Throwable cause) {
        return new QldbDriverException(message, cause);
    }
}

