/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb.exceptions;

import com.amazonaws.AmazonClientException;
import org.slf4j.Logger;

public class QldbClientException
extends AmazonClientException {
    private static String SESSION_TOKEN_PREFIX = System.lineSeparator() + "Session token: ";

    protected QldbClientException(Throwable cause) {
        super(cause);
    }

    protected QldbClientException(String message) {
        super(message);
    }

    protected QldbClientException(String message, Throwable cause) {
        super(message, cause);
    }

    public static QldbClientException create(Throwable cause, Logger logger) {
        logger.error(cause.getMessage());
        return new QldbClientException(cause);
    }

    public static QldbClientException create(String message, Logger logger) {
        logger.error(message);
        return new QldbClientException(message);
    }

    public static QldbClientException create(String message, String sessionToken, Logger logger) {
        String errorMessage = message + SESSION_TOKEN_PREFIX + sessionToken;
        return QldbClientException.create(errorMessage, logger);
    }

    public static QldbClientException create(String message, Throwable cause, Logger logger) {
        logger.error(message);
        return new QldbClientException(message, cause);
    }

    public static QldbClientException create(String message, String sessionToken, Throwable cause, Logger logger) {
        String errorMessage = message + SESSION_TOKEN_PREFIX + sessionToken;
        return QldbClientException.create(errorMessage, cause, logger);
    }
}

