/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonValue;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.qldbsession.model.InvalidSessionException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.Executor;
import software.amazon.qldb.ExecutorNoReturn;
import software.amazon.qldb.QldbSession;
import software.amazon.qldb.QldbSessionImpl;
import software.amazon.qldb.Result;
import software.amazon.qldb.RetryIndicator;
import software.amazon.qldb.Transaction;
import software.amazon.qldb.exceptions.Errors;

@NotThreadSafe
final class PooledQldbSession
implements QldbSession {
    private static final Logger logger = LoggerFactory.getLogger(PooledQldbSession.class);
    private final QldbSessionImpl session;
    private final CloseSessionAction closeAction;
    private final AtomicBoolean isClosed;

    PooledQldbSession(QldbSessionImpl session, CloseSessionAction closeAction) {
        this.session = session;
        this.closeAction = closeAction;
        this.isClosed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            this.closeAction.invoke(this.session);
        }
    }

    @Override
    public Result execute(String statement) {
        return this.invokeOnSession(() -> this.session.execute(statement));
    }

    @Override
    public Result execute(String statement, List<IonValue> parameters) {
        return this.invokeOnSession(() -> this.session.execute(statement, parameters));
    }

    @Override
    public void execute(ExecutorNoReturn executor) {
        this.invokeOnSession(() -> {
            this.session.execute(executor);
            return null;
        });
    }

    @Override
    public void execute(ExecutorNoReturn executor, RetryIndicator retryIndicator) {
        this.invokeOnSession(() -> {
            this.session.execute(executor, retryIndicator);
            return null;
        });
    }

    @Override
    public <T> T execute(Executor<T> executor) {
        return (T)this.invokeOnSession(() -> this.session.execute(executor));
    }

    @Override
    public <T> T execute(Executor<T> executor, RetryIndicator retryIndicator) {
        return (T)this.invokeOnSession(() -> this.session.execute(executor, retryIndicator));
    }

    @Override
    public String getLedgerName() {
        this.throwIfClosed();
        return this.session.getLedgerName();
    }

    @Override
    public String getSessionToken() {
        this.throwIfClosed();
        return this.session.getSessionToken();
    }

    @Override
    public Iterable<String> getTableNames() {
        return this.invokeOnSession(this.session::getTableNames);
    }

    @Override
    public Transaction startTransaction() {
        return this.invokeOnSession(this.session::startTransaction);
    }

    private void throwIfClosed() {
        if (this.isClosed.get()) {
            logger.error(Errors.SESSION_CLOSED.get());
            throw new IllegalStateException(Errors.SESSION_CLOSED.get());
        }
    }

    private <T> T invokeOnSession(Supplier<T> sessionFunction) {
        this.throwIfClosed();
        try {
            return sessionFunction.get();
        }
        catch (InvalidSessionException ise) {
            this.close();
            throw ise;
        }
    }

    @FunctionalInterface
    static interface CloseSessionAction {
        public void invoke(QldbSessionImpl var1);
    }
}

