/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazonaws.util.ValidationUtils;
import java.util.concurrent.ExecutorService;
import software.amazon.qldb.BaseQldbDriverBuilder;
import software.amazon.qldb.BaseSyncQldbDriver;
import software.amazon.qldb.Validate;

abstract class BaseSyncQldbDriverBuilder<B extends BaseSyncQldbDriverBuilder, T extends BaseSyncQldbDriver>
extends BaseQldbDriverBuilder<B, T> {
    protected static final String VERSION = "QLDB Driver for Java v";
    protected static final int DEFAULT_READAHEAD = 0;
    protected int readAhead = 0;
    protected ExecutorService executorService;

    protected BaseSyncQldbDriverBuilder() {
    }

    public B withReadAhead(int readAhead) {
        Validate.assertIsAtLeastTwo(readAhead, "readAhead");
        this.readAhead = readAhead;
        this.executorService = null;
        return (B)((BaseSyncQldbDriverBuilder)this.getSubclass());
    }

    public B withReadAhead(int readAhead, ExecutorService executorService) {
        Validate.assertIsNotNegative(readAhead, "readAhead");
        ValidationUtils.assertNotNull((Object)executorService, (String)"executorService");
        this.readAhead = readAhead;
        this.executorService = executorService;
        return (B)((BaseSyncQldbDriverBuilder)this.getSubclass());
    }

    @Override
    protected String getVersion() {
        return VERSION;
    }
}

