/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.payloadoffloading.CountingOutputStream;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    public static long getStringSizeInBytes(String str) {
        CountingOutputStream counterOutputStream = new CountingOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counterOutputStream, StandardCharsets.UTF_8);
            writer.write(str);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            String errorMessage = "Failed to calculate the size of payload.";
            LOG.error(errorMessage, (Throwable)e);
            throw SdkClientException.create((String)errorMessage, (Throwable)e);
        }
        return counterOutputStream.getTotalSize();
    }

    public static String getUserAgentHeader(String clientName) {
        return clientName + "/" + "2.20.130";
    }

    public static Throwable unwrapFutureException(Throwable t) {
        if (t instanceof CompletionException && t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

