/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.ArrayBackedAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ArrayBackedAttributesBuilder
implements AttributesBuilder {
    private final List<Object> data;

    ArrayBackedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    @Override
    public Attributes build() {
        return ArrayBackedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<Long> key, int value) {
        return this.put(key, Long.valueOf(value));
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    @Override
    public AttributesBuilder putAll(Attributes attributes) {
        if (attributes == null) {
            return this;
        }
        attributes.forEach((key, value) -> this.put((AttributeKey)key, (Object)value));
        return this;
    }

    static List<Double> toList(double ... values) {
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Long> toList(long ... values) {
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Boolean> toList(boolean ... values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }
}

