/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class MessagingAttributesExtractor<REQUEST, RESPONSE>
extends AttributesExtractor<REQUEST, RESPONSE> {
    public static final String TEMP_DESTINATION_NAME = "(temporary)";

    @Override
    protected final void onStart(AttributesBuilder attributes, REQUEST request) {
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_SYSTEM, this.system(request));
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_DESTINATION_KIND, this.destinationKind(request));
        boolean isTemporaryDestination = this.temporaryDestination(request);
        if (isTemporaryDestination) {
            MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_TEMP_DESTINATION, true);
            MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_DESTINATION, TEMP_DESTINATION_NAME);
        } else {
            MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_DESTINATION, this.destination(request));
        }
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_PROTOCOL, this.protocol(request));
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_PROTOCOL_VERSION, this.protocolVersion(request));
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_URL, this.url(request));
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_CONVERSATION_ID, this.conversationId(request));
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES, this.messagePayloadSize(request));
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES, this.messagePayloadCompressedSize(request));
        MessageOperation operation = this.operation(request);
        if (operation == MessageOperation.RECEIVE || operation == MessageOperation.PROCESS) {
            MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_OPERATION, operation.operationName());
        }
    }

    @Override
    protected final void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        MessagingAttributesExtractor.set(attributes, SemanticAttributes.MESSAGING_MESSAGE_ID, this.messageId(request, response));
    }

    protected abstract @Nullable String system(REQUEST var1);

    protected abstract @Nullable String destinationKind(REQUEST var1);

    protected abstract @Nullable String destination(REQUEST var1);

    protected abstract boolean temporaryDestination(REQUEST var1);

    protected abstract @Nullable String protocol(REQUEST var1);

    protected abstract @Nullable String protocolVersion(REQUEST var1);

    protected abstract @Nullable String url(REQUEST var1);

    protected abstract @Nullable String conversationId(REQUEST var1);

    protected abstract @Nullable Long messagePayloadSize(REQUEST var1);

    protected abstract @Nullable Long messagePayloadCompressedSize(REQUEST var1);

    protected abstract @Nullable MessageOperation operation(REQUEST var1);

    protected abstract @Nullable String messageId(REQUEST var1, @Nullable RESPONSE var2);
}

