/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.InternalNetClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.url.internal.UrlAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;

public final class HttpClientAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpClientAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private final InternalNetClientAttributesExtractor<REQUEST, RESPONSE> internalNetExtractor;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST, RESPONSE> internalServerExtractor;
    private final ToIntFunction<Context> resendCountIncrementer;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return HttpClientAttributesExtractor.builder(httpAttributesGetter).build();
    }

    @Deprecated
    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return HttpClientAttributesExtractor.builder(httpAttributesGetter, netAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return new HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, httpAttributesGetter);
    }

    @Deprecated
    public static <REQUEST, RESPONSE> HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return new HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, netAttributesGetter);
    }

    HttpClientAttributesExtractor(HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder) {
        super(builder.httpAttributesGetter, builder.capturedRequestHeaders, builder.capturedResponseHeaders, builder.knownMethods);
        this.internalNetExtractor = builder.buildNetExtractor();
        this.internalNetworkExtractor = builder.buildNetworkExtractor();
        this.internalServerExtractor = builder.buildServerExtractor();
        this.resendCountIncrementer = builder.resendCountIncrementer;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.internalServerExtractor.onStart(attributes, request);
        String fullUrl = HttpClientAttributesExtractor.stripSensitiveData(((HttpClientAttributesGetter)this.getter).getUrlFull(request));
        if (SemconvStability.emitStableHttpSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, UrlAttributes.URL_FULL, fullUrl);
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_URL, fullUrl);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.internalNetExtractor.onEnd(attributes, request, response);
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        this.internalServerExtractor.onEnd(attributes, request, response);
        int resendCount = this.resendCountIncrementer.applyAsInt(context);
        if (resendCount > 0) {
            attributes.put(SemanticAttributes.HTTP_RESEND_COUNT, resendCount);
        }
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_CLIENT;
    }

    @Nullable
    private static String stripSensitiveData(@Nullable String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        int schemeEndIndex = url.indexOf(58);
        if (schemeEndIndex == -1) {
            return url;
        }
        int len = url.length();
        if (len <= schemeEndIndex + 2 || url.charAt(schemeEndIndex + 1) != '/' || url.charAt(schemeEndIndex + 2) != '/') {
            return url;
        }
        int atIndex = -1;
        for (int index = schemeEndIndex + 3; index < len; ++index) {
            char c = url.charAt(index);
            if (c == '@') {
                atIndex = index;
            }
            if (c == '/' || c == '?' || c == '#') break;
        }
        if (atIndex == -1 || atIndex == len - 1) {
            return url;
        }
        return url.substring(0, schemeEndIndex + 3) + "REDACTED:REDACTED" + url.substring(atIndex);
    }
}

