/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.BiPredicate;

public final class InternalNetServerAttributesExtractor<REQUEST> {
    private final NetServerAttributesGetter<REQUEST> getter;
    private final BiPredicate<Integer, REQUEST> captureHostPortCondition;
    private final FallbackNamePortGetter<REQUEST> fallbackNamePortGetter;

    public InternalNetServerAttributesExtractor(NetServerAttributesGetter<REQUEST> getter, BiPredicate<Integer, REQUEST> captureHostPortCondition, FallbackNamePortGetter<REQUEST> fallbackNamePortGetter) {
        this.getter = getter;
        this.captureHostPortCondition = captureHostPortCondition;
        this.fallbackNamePortGetter = fallbackNamePortGetter;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String sockFamily;
        String sockHostAddr;
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.transport(request));
        boolean setSockFamily = false;
        String sockPeerAddr = this.getter.sockPeerAddr(request);
        if (sockPeerAddr != null) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_ADDR, sockPeerAddr);
            Integer sockPeerPort = this.getter.sockPeerPort(request);
            if (sockPeerPort != null && sockPeerPort > 0) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_PEER_PORT, Long.valueOf(sockPeerPort.intValue()));
            }
        }
        String hostName = this.extractHostName(request);
        Integer hostPort = this.extractHostPort(request);
        if (hostName != null) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_HOST_NAME, hostName);
            if (hostPort != null && hostPort > 0 && this.captureHostPortCondition.test(hostPort, request)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_HOST_PORT, Long.valueOf(hostPort.intValue()));
            }
        }
        if ((sockHostAddr = this.getter.sockHostAddr(request)) != null && !sockHostAddr.equals(hostName)) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_HOST_ADDR, sockHostAddr);
            Integer sockHostPort = this.getter.sockHostPort(request);
            if (sockHostPort != null && sockHostPort > 0 && !sockHostPort.equals(hostPort)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_HOST_PORT, Long.valueOf(sockHostPort.intValue()));
            }
        }
        if (setSockFamily && (sockFamily = this.getter.sockFamily(request)) != null && !"inet".equals(sockFamily)) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_FAMILY, sockFamily);
        }
    }

    private String extractHostName(REQUEST request) {
        String peerName = this.getter.hostName(request);
        if (peerName == null) {
            peerName = this.fallbackNamePortGetter.name(request);
        }
        return peerName;
    }

    private Integer extractHostPort(REQUEST request) {
        Integer peerPort = this.getter.hostPort(request);
        if (peerPort == null) {
            peerPort = this.fallbackNamePortGetter.port(request);
        }
        return peerPort;
    }
}

