/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class NetServerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    public static final AttributeKey<String> NET_SOCK_PEER_ADDR = AttributeKey.stringKey("net.sock.peer.addr");
    public static final AttributeKey<Long> NET_SOCK_PEER_PORT = AttributeKey.longKey("net.sock.peer.port");
    private final NetServerAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> NetServerAttributesExtractor<REQUEST, RESPONSE> create(NetServerAttributesGetter<REQUEST> getter) {
        return new NetServerAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private NetServerAttributesExtractor(NetServerAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.transport(request));
        String sockPeerAddr = this.getter.sockPeerAddr(request);
        AttributesExtractorUtil.internalSet(attributes, NET_SOCK_PEER_ADDR, sockPeerAddr);
        Integer sockPeerPort = this.getter.sockPeerPort(request);
        if (sockPeerPort != null && sockPeerPort > 0) {
            AttributesExtractorUtil.internalSet(attributes, NET_SOCK_PEER_PORT, Long.valueOf(sockPeerPort.intValue()));
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

