/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.servlet;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import javax.annotation.Nullable;

public class AppServerBridge {
    private static final ContextKey<AppServerBridge> CONTEXT_KEY = ContextKey.named("opentelemetry-servlet-app-server-bridge");
    private final boolean servletShouldRecordException;
    private boolean captureServletAttributes;
    private Throwable exception;

    private AppServerBridge(Builder builder) {
        this.servletShouldRecordException = builder.recordException;
        this.captureServletAttributes = builder.captureServletAttributes;
    }

    public static void recordException(Context context, Throwable exception) {
        AppServerBridge appServerBridge = context.get(CONTEXT_KEY);
        if (appServerBridge != null && appServerBridge.servletShouldRecordException) {
            appServerBridge.exception = exception;
        }
    }

    @Nullable
    public static Throwable getException(Context context) {
        AppServerBridge appServerBridge = context.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            return appServerBridge.exception;
        }
        return null;
    }

    public static boolean captureServletAttributes(Context context) {
        AppServerBridge appServerBridge = context.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            boolean result = appServerBridge.captureServletAttributes;
            appServerBridge.captureServletAttributes = false;
            return result;
        }
        return false;
    }

    public static Class<?> getCallDepthKey() {
        class Key {
            Key() {
            }
        }
        return Key.class;
    }

    public static class Builder {
        boolean recordException;
        boolean captureServletAttributes;

        public Builder recordException() {
            this.recordException = true;
            return this;
        }

        public Builder captureServletAttributes() {
            this.captureServletAttributes = true;
            return this;
        }

        public Context init(Context context) {
            return context.with(CONTEXT_KEY, new AppServerBridge(this));
        }
    }
}

