/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ClientSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ServerSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> extractors;
    private final ErrorCauseExtractor errorCauseExtractor;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> newBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(String instrumentationName, Tracer tracer, SpanNameExtractor<? super REQUEST> spanNameExtractor, SpanKindExtractor<? super REQUEST> spanKindExtractor, SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor, List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> extractors, ErrorCauseExtractor errorCauseExtractor) {
        this.instrumentationName = instrumentationName;
        this.tracer = tracer;
        this.spanNameExtractor = spanNameExtractor;
        this.spanKindExtractor = spanKindExtractor;
        this.spanStatusExtractor = spanStatusExtractor;
        this.extractors = extractors;
        this.errorCauseExtractor = errorCauseExtractor;
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        boolean suppressed = false;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        switch (spanKind) {
            case SERVER: {
                suppressed = ServerSpan.fromContextOrNull(parentContext) != null;
                break;
            }
            case CLIENT: {
                suppressed = ClientSpan.fromContextOrNull(parentContext) != null;
                break;
            }
        }
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    public Context start(Context parentContext, REQUEST request) {
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind).setParent(parentContext);
        AttributesBuilder attributes = Attributes.builder();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.extractors) {
            extractor.onStart(attributes, request);
        }
        attributes.build().forEach((key, value) -> spanBuilder.setAttribute(key, value));
        Span span = spanBuilder.startSpan();
        Context context = parentContext.with(span);
        switch (spanKind) {
            case SERVER: {
                return ServerSpan.with(context, span);
            }
            case CLIENT: {
                return ClientSpan.with(context, span);
            }
        }
        return context;
    }

    public void end(Context context, REQUEST request, RESPONSE response, @Nullable Throwable error) {
        Span span = Span.fromContext(context);
        AttributesBuilder attributes = Attributes.builder();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.extractors) {
            extractor.onEnd(attributes, request, response);
        }
        attributes.build().forEach((key, value) -> span.setAttribute(key, value));
        if (error != null) {
            error = this.errorCauseExtractor.extractCause(error);
            span.recordException(error);
        }
        span.setStatus(this.spanStatusExtractor.extract(request, response, error));
        span.end();
    }
}

