/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GitProperties {
    public static final GitProperties FromResource = GitProperties.fromResource();
    private final String commitId;
    private final String buildVersion;
    private final String commitTime;
    private final String buildTime;

    private GitProperties(String commitId, String buildVersion, String commitTime, String buildTime) {
        this.commitId = commitId;
        this.buildVersion = buildVersion;
        this.commitTime = commitTime;
        this.buildTime = buildTime;
    }

    private static GitProperties fromResource() {
        Properties properties;
        block8: {
            properties = new Properties();
            try {
                InputStream stream = ClassLoader.getSystemResourceAsStream("git.properties");
                if (stream != null) {
                    properties.load(stream);
                    stream.close();
                    break block8;
                }
                File file = new File("/var/task/git.properties");
                if (!file.exists()) break block8;
                try (FileInputStream filestream = new FileInputStream(file);){
                    properties.load(filestream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new GitProperties(properties.getProperty("git.commit.id", "unknown"), properties.getProperty("git.build.version", "unknown"), properties.getProperty("git.commit.time", "unknown"), properties.getProperty("git.build.time", "unknown"));
    }

    public String toString() {
        return "[buildVersion='" + this.buildVersion + "', buildTime='" + this.buildTime + "', commitId='" + this.commitId + "', commitTime='" + this.commitTime + "']";
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public String getBuildTime() {
        return this.buildTime;
    }
}

