/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.credentials.V1toV2CredentialsProvider;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.ApprovalResult;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.neptunedata.NeptunedataClient;
import software.amazon.awssdk.services.neptunedata.NeptunedataClientBuilder;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusResponse;

public class StatusEndpointFilter
implements EndpointFilter {
    private static final Logger logger = LoggerFactory.getLogger(StatusEndpointFilter.class);
    private static final long DEFAULT_TIMEOUT_MILLIS = 2000L;
    private static final String STATE_HEALTHY = "healthy";
    private final Region region;
    private final AwsCredentialsProvider credentialsProvider;
    private final long timeoutMillis;

    public StatusEndpointFilter(Region region, AwsCredentialsProvider credentialsProvider, long timeoutMillis) {
        this.region = region;
        this.credentialsProvider = credentialsProvider;
        this.timeoutMillis = timeoutMillis;
    }

    public StatusEndpointFilter(Region region, AwsCredentialsProvider credentialsProvider) {
        this(region, credentialsProvider, 2000L);
    }

    public StatusEndpointFilter(Region region, AWSCredentialsProvider credentialsProvider, long timeoutMillis) {
        this(region, V1toV2CredentialsProvider.create((AWSCredentialsProvider)credentialsProvider), timeoutMillis);
    }

    public StatusEndpointFilter(Region region, AWSCredentialsProvider credentialsProvider) {
        this(region, credentialsProvider, 2000L);
    }

    @Override
    public ApprovalResult approveEndpoint(Endpoint endpoint) {
        Map<String, String> annotations = endpoint.getAnnotations();
        ApprovalResult approvalResult = ApprovalResult.APPROVED;
        if (annotations.containsKey("AWS:endpoint_state") && !annotations.get("AWS:endpoint_state").equals(STATE_HEALTHY)) {
            approvalResult = new ApprovalResult(false, annotations.get("AWS:endpoint_state"));
        }
        logger.info("Approval result: {}", (Object)approvalResult);
        return approvalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint enrichEndpoint(Endpoint endpoint) {
        String statusUrl = String.format("https://%s:8182/status", endpoint.getAddress());
        URI endpointUri = URI.create(statusUrl);
        logger.info("Endpoint URI: {}", (Object)endpointUri);
        ClientOverrideConfiguration configuration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallTimeout(Duration.ofMillis(this.timeoutMillis)).build();
        try (NeptunedataClient client = (NeptunedataClient)((NeptunedataClientBuilder)((NeptunedataClientBuilder)((NeptunedataClientBuilder)((NeptunedataClientBuilder)NeptunedataClient.builder().credentialsProvider(this.credentialsProvider)).region(this.region)).endpointOverride(endpointUri)).overrideConfiguration(configuration)).build();){
            GetEngineStatusResponse engineStatus = client.getEngineStatus((GetEngineStatusRequest)GetEngineStatusRequest.builder().build());
            endpoint.setAnnotation("AWS:endpoint_state", engineStatus.status());
            logger.info("Endpoint status: {} [{}]", (Object)endpointUri, (Object)engineStatus.status());
        }
        return endpoint;
    }
}

