/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.IgnoresSelectedExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndpointClient
implements IgnoresSelectedExceptions {
    private static final Logger logger = LoggerFactory.getLogger(EndpointClient.class);
    private final Endpoint endpoint;
    private final Client client;

    public static List<EndpointClient> create(Map<Endpoint, Cluster> endpointClusters, Map<Class<? extends Exception>, Set<String>> explicitlySetIgnorableExceptions) {
        return EndpointClient.create(endpointClusters, cluster -> cluster.connect().init(), explicitlySetIgnorableExceptions);
    }

    static List<EndpointClient> create(Map<Endpoint, Cluster> endpointClusters, Function<Cluster, Client> clientFactory, Map<Class<? extends Exception>, Set<String>> explicitlySetIgnorableExceptions) {
        ArrayList<EndpointClient> results = new ArrayList<EndpointClient>();
        Map<Class<? extends Exception>, Set<String>> ignorableExceptions = IgnoresSelectedExceptions.getIgnorableExceptions();
        for (Map.Entry<Endpoint, Cluster> entry : endpointClusters.entrySet()) {
            Client client;
            Cluster cluster = entry.getValue();
            Endpoint endpoint = entry.getKey();
            try {
                client = clientFactory.apply(cluster);
            }
            catch (Exception ex) {
                if (ignorableExceptions.containsKey(ex.getClass()) && ignorableExceptions.get(ex.getClass()).contains(ex.getMessage()) || explicitlySetIgnorableExceptions.containsKey(ex.getClass()) && explicitlySetIgnorableExceptions.get(ex.getClass()).contains(ex.getMessage())) {
                    logger.warn("Ignoring exception for endpoint: {}", (Object)endpoint, (Object)ex);
                    continue;
                }
                logger.error("Failed to create client for endpoint: {}", (Object)endpoint, (Object)ex);
                throw ex;
            }
            results.add(new EndpointClient(endpoint, client));
        }
        return results;
    }

    EndpointClient(Endpoint endpoint, Client client) {
        this.endpoint = endpoint;
        this.client = client;
    }

    public boolean isAvailable() {
        return !this.client.getCluster().availableHosts().isEmpty();
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Client client() {
        return this.client;
    }

    public void initClient() {
        this.client.init();
    }

    public CompletableFuture<Void> closeClientAsync() {
        return this.client.closeAsync();
    }
}

