/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;

class IamAuthConfig {
    public static final String DEFAULT_PROFILE = "default";
    private final List<String> endpoints;
    private final int port;
    private final boolean connectViaLoadBalancer;
    private final boolean enableIamAuth;
    private final boolean removeHostHeaderAfterSigning;
    private final String serviceRegion;
    private final String iamProfile;
    private final AwsCredentialsProvider credentials;
    private final Random random = new Random(System.currentTimeMillis());

    public static IamAuthConfigBuilder builder() {
        return new IamAuthConfigBuilder();
    }

    IamAuthConfig(Collection<String> endpoints, int port, boolean enableIamAuth, boolean connectViaLoadBalancer, boolean removeHostHeaderAfterSigning, String serviceRegion, String iamProfile, AwsCredentialsProvider credentials) {
        this.endpoints = new ArrayList<String>(endpoints);
        this.port = port;
        this.enableIamAuth = enableIamAuth;
        this.connectViaLoadBalancer = connectViaLoadBalancer;
        this.removeHostHeaderAfterSigning = removeHostHeaderAfterSigning;
        this.serviceRegion = serviceRegion;
        this.iamProfile = iamProfile;
        this.credentials = credentials;
    }

    public String serviceRegion() {
        return this.serviceRegion;
    }

    public AwsCredentialsProviderChain credentialsProviderChain() {
        if (this.credentials != null) {
            return AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{this.credentials});
        }
        if (!this.iamProfile.equals(DEFAULT_PROFILE)) {
            return AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{ProfileCredentialsProvider.create((String)this.iamProfile)});
        }
        return AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{DefaultCredentialsProvider.create()});
    }

    public String chooseHostHeader() {
        String address = this.endpoints.size() == 1 ? this.endpoints.get(0) : this.endpoints.get(this.random.nextInt(this.endpoints.size()));
        return String.format("%s:%s", address, this.port);
    }

    public boolean enableIamAuth() {
        return this.enableIamAuth;
    }

    public boolean connectViaLoadBalancer() {
        return this.connectViaLoadBalancer;
    }

    public boolean removeHostHeaderAfterSigning() {
        return this.removeHostHeaderAfterSigning;
    }

    public String asJsonString() {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        for (String endpoint : this.endpoints) {
            arrayNode.add(endpoint);
        }
        json.set("endpoints", (JsonNode)arrayNode);
        json.put("port", this.port);
        json.put("enableIamAuth", this.enableIamAuth);
        json.put("connectViaLoadBalancer", this.connectViaLoadBalancer);
        json.put("removeHostHeaderAfterSigning", this.removeHostHeaderAfterSigning);
        json.put("serviceRegion", this.serviceRegion);
        json.put("iamProfile", this.iamProfile);
        return json.toString();
    }

    public String toString() {
        return this.asJsonString();
    }

    public static final class IamAuthConfigBuilder {
        private final List<String> endpoints = new ArrayList<String>();
        private int port = 8182;
        private boolean enableIamAuth = false;
        private boolean connectViaLoadBalancer = false;
        private boolean removeHostHeaderAfterSigning = false;
        private String serviceRegion = "";
        private String iamProfile = "default";
        private AwsCredentialsProvider credentials = null;

        public IamAuthConfigBuilder addNeptuneEndpoints(String ... endpoints) {
            this.endpoints.addAll(Arrays.asList(endpoints));
            return this;
        }

        public IamAuthConfigBuilder addNeptuneEndpoints(List<String> endpoints) {
            this.endpoints.addAll(endpoints);
            return this;
        }

        public IamAuthConfigBuilder setNeptunePort(int port) {
            this.port = port;
            return this;
        }

        public IamAuthConfigBuilder setServiceRegion(String serviceRegion) {
            this.serviceRegion = serviceRegion;
            return this;
        }

        public IamAuthConfigBuilder setIamProfile(String iamProfile) {
            this.iamProfile = iamProfile;
            return this;
        }

        public IamAuthConfigBuilder setCredentials(AwsCredentialsProvider credentials) {
            this.credentials = credentials;
            return this;
        }

        public IamAuthConfigBuilder enableIamAuth() {
            this.enableIamAuth = true;
            return this;
        }

        public IamAuthConfigBuilder removeHostHeaderAfterSigning() {
            this.removeHostHeaderAfterSigning = true;
            return this;
        }

        public IamAuthConfigBuilder connectViaLoadBalancer() {
            this.connectViaLoadBalancer = true;
            return this;
        }

        public IamAuthConfig build() {
            return new IamAuthConfig(this.endpoints, this.port, this.enableIamAuth, this.connectViaLoadBalancer, this.removeHostHeaderAfterSigning, this.serviceRegion, this.iamProfile, this.credentials);
        }
    }
}

