/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.neptune.cluster.NeptuneInstanceMetadata;

public enum EndpointsType implements EndpointsSelector
{
    ClusterEndpoint{

        @Override
        public EndpointCollection getEndpoints(NeptuneClusterMetadata clusterMetadata) {
            return new EndpointCollection(Collections.singletonList(clusterMetadata.getClusterEndpoint()));
        }
    }
    ,
    ReaderEndpoint{

        @Override
        public EndpointCollection getEndpoints(NeptuneClusterMetadata clusterMetadata) {
            return new EndpointCollection(Collections.singletonList(clusterMetadata.getReaderEndpoint()));
        }
    }
    ,
    All{

        @Override
        public EndpointCollection getEndpoints(NeptuneClusterMetadata clusterMetadata) {
            List results = clusterMetadata.getInstances().stream().filter(NeptuneInstanceMetadata::isAvailable).collect(Collectors.toList());
            if (results.isEmpty()) {
                logger.warn("Unable to get any endpoints so getting ReaderEndpoint instead");
                return ReaderEndpoint.getEndpoints(clusterMetadata);
            }
            return new EndpointCollection(results);
        }
    }
    ,
    Primary{

        @Override
        public EndpointCollection getEndpoints(NeptuneClusterMetadata clusterMetadata) {
            List results = clusterMetadata.getInstances().stream().filter(NeptuneInstanceMetadata::isPrimary).filter(NeptuneInstanceMetadata::isAvailable).collect(Collectors.toList());
            if (results.isEmpty()) {
                logger.warn("Unable to get Primary endpoint so getting ClusterEndpoint instead");
                return ClusterEndpoint.getEndpoints(clusterMetadata);
            }
            return new EndpointCollection(results);
        }
    }
    ,
    ReadReplicas{

        @Override
        public EndpointCollection getEndpoints(NeptuneClusterMetadata clusterMetadata) {
            List results = clusterMetadata.getInstances().stream().filter(NeptuneInstanceMetadata::isReader).filter(NeptuneInstanceMetadata::isAvailable).collect(Collectors.toList());
            if (results.isEmpty()) {
                logger.warn("Unable to get ReadReplicas endpoints so getting ReaderEndpoint instead");
                return ReaderEndpoint.getEndpoints(clusterMetadata);
            }
            return new EndpointCollection(results);
        }
    };

    private static final Logger logger;

    static {
        logger = LoggerFactory.getLogger(EndpointsType.class);
    }
}

