/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.ErrorMetric;

public class EndpointRequestMetrics {
    private final long start = System.currentTimeMillis();
    private final String address;
    private long totalDurationMillis;
    private long minMillis = 0L;
    private long maxMillis = 0L;
    private long successCount;
    private long errorCount;
    private final ConcurrentHashMap<Class<? extends Throwable>, ErrorMetric> errors = new ConcurrentHashMap();

    public EndpointRequestMetrics(String address) {
        this.address = address;
    }

    public void update(long duration, Throwable e) {
        this.totalDurationMillis += duration;
        if (duration > this.maxMillis) {
            this.maxMillis = duration;
        }
        if (duration < this.minMillis) {
            this.minMillis = duration;
        }
        if (e == null) {
            ++this.successCount;
        } else {
            this.errors.compute(e.getClass(), new BiFunction<Class<? extends Throwable>, ErrorMetric, ErrorMetric>(){

                @Override
                public ErrorMetric apply(Class<? extends Throwable> aClass, ErrorMetric errorMetric) {
                    if (errorMetric == null) {
                        return new ErrorMetric(aClass).increment();
                    }
                    return errorMetric.increment();
                }
            });
            ++this.errorCount;
        }
    }

    public String getAddress() {
        return this.address;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public double getRatePerSecond() {
        long duration = System.currentTimeMillis() - this.start;
        return (double)this.successCount / ((double)duration / 1000.0);
    }

    public double getAverageLatencyMillis() {
        return (double)this.totalDurationMillis / (double)this.successCount;
    }

    public long getMinLatencyMillis() {
        return this.minMillis;
    }

    public long getMaxLatencyMillis() {
        return this.maxMillis;
    }

    public Collection<ErrorMetric> getErrors() {
        return this.errors.values();
    }

    public String toString() {
        String errorString = this.getErrors().isEmpty() ? "" : String.format(", errors: [%s]", this.getErrors().stream().map(ErrorMetric::toString).collect(Collectors.joining(", ")));
        return String.format("%s [succeeded: %s, failed: %s, ratePerSec: %.3f, minMillis: %s, maxMillis: %s, avgMillis: %.2f%s]", this.getAddress(), this.getSuccessCount(), this.getErrorCount(), this.getRatePerSecond(), this.getMinLatencyMillis(), this.getMaxLatencyMillis(), this.getAverageLatencyMillis(), errorString);
    }
}

