/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import org.apache.tinkerpop.gremlin.driver.ConnectionAttemptManager;
import org.apache.tinkerpop.gremlin.driver.GremlinClient;
import org.apache.tinkerpop.gremlin.driver.OnEagerRefresh;

class AcquireConnectionConfig {
    private final int maxWaitForConnection;
    private final int eagerRefreshWaitTimeMillis;
    private final OnEagerRefresh onEagerRefresh;
    private final int eagerRefreshBackoffMillis;
    private final int acquireConnectionBackoffMillis;

    AcquireConnectionConfig(int maxWaitForConnection, int eagerRefreshWaitTimeMillis, OnEagerRefresh onEagerRefresh, int eagerRefreshBackoffMillis, int acquireConnectionBackoffMillis) {
        this.maxWaitForConnection = maxWaitForConnection;
        this.eagerRefreshWaitTimeMillis = eagerRefreshWaitTimeMillis;
        this.onEagerRefresh = onEagerRefresh;
        this.eagerRefreshBackoffMillis = eagerRefreshBackoffMillis;
        this.acquireConnectionBackoffMillis = acquireConnectionBackoffMillis;
    }

    public ConnectionAttemptManager createConnectionAttemptManager(GremlinClient gremlinClient) {
        return new ConnectionAttemptManager(gremlinClient, this.maxWaitForConnection, this.eagerRefreshWaitTimeMillis, this.onEagerRefresh, this.eagerRefreshBackoffMillis, () -> System.currentTimeMillis());
    }

    public int acquireConnectionBackoffMillis() {
        return this.acquireConnectionBackoffMillis;
    }
}

