/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.neptune.auth.NeptuneNettyHttpSigV4Signer;
import com.amazonaws.neptune.auth.NeptuneSigV4SignerException;
import io.netty.handler.codec.http.FullHttpRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.HandshakeInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.neptune.cluster.IamAuthConfig;
import software.amazon.utils.RegionUtils;

class LBAwareHandshakeInterceptor
implements HandshakeInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LBAwareHandshakeInterceptor.class);
    private final IamAuthConfig iamAuthConfig;
    private final String serviceRegion;

    LBAwareHandshakeInterceptor(IamAuthConfig iamAuthConfig) {
        this.iamAuthConfig = iamAuthConfig;
        this.serviceRegion = this.getServiceRegion();
    }

    public FullHttpRequest apply(FullHttpRequest request) {
        logger.trace("iamAuthConfig: {}, serviceRegion: {}", (Object)this.iamAuthConfig, (Object)this.serviceRegion);
        if (this.iamAuthConfig.enableIamAuth() || this.iamAuthConfig.connectViaLoadBalancer()) {
            request.headers().remove("Host");
            request.headers().remove("host");
            request.headers().add("Host", (Object)this.iamAuthConfig.chooseHostHeader());
        }
        if (this.iamAuthConfig.enableIamAuth()) {
            try {
                NeptuneNettyHttpSigV4Signer sigV4Signer = new NeptuneNettyHttpSigV4Signer(this.serviceRegion, (AWSCredentialsProvider)this.iamAuthConfig.credentialsProviderChain());
                sigV4Signer.signRequest((Object)request);
                if (this.iamAuthConfig.removeHostHeaderAfterSigning()) {
                    request.headers().remove("Host");
                }
            }
            catch (NeptuneSigV4SignerException e) {
                throw new RuntimeException("Exception occurred while signing the request", e);
            }
        }
        return request;
    }

    private String getServiceRegion() {
        if (StringUtils.isNotEmpty((CharSequence)this.iamAuthConfig.serviceRegion())) {
            logger.debug("Using service region supplied in config");
            return this.iamAuthConfig.serviceRegion();
        }
        if (StringUtils.isNotEmpty((CharSequence)System.getenv("SERVICE_REGION"))) {
            logger.debug("Using SERVICE_REGION environment variable as service region");
            return StringUtils.trim((String)System.getenv("SERVICE_REGION"));
        }
        if (StringUtils.isNotEmpty((CharSequence)System.getProperty("SERVICE_REGION"))) {
            logger.debug("Using SERVICE_REGION system property as service region");
            return StringUtils.trim((String)System.getProperty("SERVICE_REGION"));
        }
        String currentRegionName = RegionUtils.getCurrentRegionName();
        if (currentRegionName != null) {
            logger.debug("Using current region as service region");
            return currentRegionName;
        }
        throw new IllegalStateException("Unable to determine Neptune service region. Use the SERVICE_REGION environment variable or system property, or the NeptuneGremlinClusterBuilder.serviceRegion() method to specify the Neptune service region.");
    }
}

